/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.KeyboardButtonRequestGeoLocation;
import telegram4j.tl.api.TlObject;

public final class ImmutableKeyboardButtonRequestGeoLocation
implements KeyboardButtonRequestGeoLocation {
    private final int identifier;
    private final String text;

    private ImmutableKeyboardButtonRequestGeoLocation(String text) {
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = KeyboardButtonRequestGeoLocation.super.identifier();
    }

    private ImmutableKeyboardButtonRequestGeoLocation(Builder builder) {
        this.text = builder.text;
        this.identifier = builder.identifierIsSet() ? builder.identifier : KeyboardButtonRequestGeoLocation.super.identifier();
    }

    private ImmutableKeyboardButtonRequestGeoLocation(int identifier, String text) {
        this.identifier = identifier;
        this.text = text;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableKeyboardButtonRequestGeoLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableKeyboardButtonRequestGeoLocation(value, this.text);
    }

    public final ImmutableKeyboardButtonRequestGeoLocation withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonRequestGeoLocation(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyboardButtonRequestGeoLocation && this.equalTo(0, (ImmutableKeyboardButtonRequestGeoLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyboardButtonRequestGeoLocation another) {
        return this.identifier == another.identifier && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "KeyboardButtonRequestGeoLocation{identifier=" + this.identifier + ", text=" + this.text + "}";
    }

    public static ImmutableKeyboardButtonRequestGeoLocation of(String text) {
        return new ImmutableKeyboardButtonRequestGeoLocation(text);
    }

    public static ImmutableKeyboardButtonRequestGeoLocation copyOf(KeyboardButtonRequestGeoLocation instance) {
        if (instance instanceof ImmutableKeyboardButtonRequestGeoLocation) {
            return (ImmutableKeyboardButtonRequestGeoLocation)instance;
        }
        return ImmutableKeyboardButtonRequestGeoLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String text;

        private Builder() {
        }

        public final Builder from(KeyboardButtonRequestGeoLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            KeyboardButton instance;
            long bits = 0L;
            if (object instanceof KeyboardButtonRequestGeoLocation) {
                instance = (KeyboardButtonRequestGeoLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableKeyboardButtonRequestGeoLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyboardButtonRequestGeoLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build KeyboardButtonRequestGeoLocation, some of required attributes are not set " + attributes;
        }
    }
}

