/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.KeyboardButtonRequestPoll;
import telegram4j.tl.api.TlObject;

public final class ImmutableKeyboardButtonRequestPoll
implements KeyboardButtonRequestPoll {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Boolean quiz;
    private final String text;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKeyboardButtonRequestPoll(String text) {
        this.text = Objects.requireNonNull(text, "text");
        this.quiz = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableKeyboardButtonRequestPoll(Builder builder) {
        this.quiz = builder.quiz;
        this.text = builder.text;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableKeyboardButtonRequestPoll(int identifier, int flags, @Nullable Boolean quiz, String text) {
        this.identifier = identifier;
        this.flags = flags;
        this.quiz = quiz;
        this.text = text;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return KeyboardButtonRequestPoll.super.identifier();
    }

    private int flagsInitialize() {
        return KeyboardButtonRequestPoll.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Boolean quiz() {
        return this.quiz;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableKeyboardButtonRequestPoll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableKeyboardButtonRequestPoll(value, this.flags, this.quiz, this.text);
    }

    public final ImmutableKeyboardButtonRequestPoll withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableKeyboardButtonRequestPoll(this.identifier, value, this.quiz, this.text);
    }

    public final ImmutableKeyboardButtonRequestPoll withQuiz(@Nullable Boolean value) {
        if (Objects.equals(this.quiz, value)) {
            return this;
        }
        return new ImmutableKeyboardButtonRequestPoll(this.identifier, this.flags, value, this.text);
    }

    public final ImmutableKeyboardButtonRequestPoll withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonRequestPoll(this.identifier, this.flags, this.quiz, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyboardButtonRequestPoll && this.equalTo(0, (ImmutableKeyboardButtonRequestPoll)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyboardButtonRequestPoll another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.quiz, another.quiz) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.quiz);
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "KeyboardButtonRequestPoll{identifier=" + this.identifier + ", flags=" + this.flags + ", quiz=" + this.quiz + ", text=" + this.text + "}";
    }

    public static ImmutableKeyboardButtonRequestPoll of(String text) {
        return new ImmutableKeyboardButtonRequestPoll(text);
    }

    public static ImmutableKeyboardButtonRequestPoll copyOf(KeyboardButtonRequestPoll instance) {
        if (instance instanceof ImmutableKeyboardButtonRequestPoll) {
            return (ImmutableKeyboardButtonRequestPoll)instance;
        }
        return ImmutableKeyboardButtonRequestPoll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private Boolean quiz;
        private String text;

        private Builder() {
        }

        public final Builder from(KeyboardButtonRequestPoll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            KeyboardButton instance;
            long bits = 0L;
            if (object instanceof KeyboardButtonRequestPoll) {
                instance = (KeyboardButtonRequestPoll)object;
                Boolean quizValue = instance.quiz();
                if (quizValue != null) {
                    this.quiz(quizValue);
                }
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder quiz(@Nullable Boolean quiz) {
            this.quiz = quiz;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableKeyboardButtonRequestPoll build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyboardButtonRequestPoll(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build KeyboardButtonRequestPoll, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableKeyboardButtonRequestPoll.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableKeyboardButtonRequestPoll.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build KeyboardButtonRequestPoll, attribute initializers form cycle " + attributes;
        }
    }
}

