/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.KeyboardButtonRow;
import telegram4j.tl.api.TlObject;

public final class ImmutableKeyboardButtonRow
implements KeyboardButtonRow {
    private final int identifier;
    private final List<KeyboardButton> buttons;

    private ImmutableKeyboardButtonRow(Builder builder) {
        this.buttons = ImmutableKeyboardButtonRow.createUnmodifiableList(true, builder.buttons);
        this.identifier = builder.identifierIsSet() ? builder.identifier : KeyboardButtonRow.super.identifier();
    }

    private ImmutableKeyboardButtonRow(int identifier, List<KeyboardButton> buttons) {
        this.identifier = identifier;
        this.buttons = buttons;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<KeyboardButton> buttons() {
        return this.buttons;
    }

    public final ImmutableKeyboardButtonRow withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableKeyboardButtonRow(value, this.buttons);
    }

    public final ImmutableKeyboardButtonRow withButtons(KeyboardButton ... elements) {
        List<KeyboardButton> newValue = ImmutableKeyboardButtonRow.createUnmodifiableList(false, ImmutableKeyboardButtonRow.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableKeyboardButtonRow(this.identifier, newValue);
    }

    public final ImmutableKeyboardButtonRow withButtons(Iterable<? extends KeyboardButton> elements) {
        if (this.buttons == elements) {
            return this;
        }
        List<KeyboardButton> newValue = ImmutableKeyboardButtonRow.createUnmodifiableList(false, ImmutableKeyboardButtonRow.createSafeList(elements, true, false));
        return new ImmutableKeyboardButtonRow(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyboardButtonRow && this.equalTo(0, (ImmutableKeyboardButtonRow)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyboardButtonRow another) {
        return this.identifier == another.identifier && this.buttons.equals(another.buttons);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.buttons.hashCode();
        return h;
    }

    public String toString() {
        return "KeyboardButtonRow{identifier=" + this.identifier + ", buttons=" + this.buttons + "}";
    }

    public static ImmutableKeyboardButtonRow copyOf(KeyboardButtonRow instance) {
        if (instance instanceof ImmutableKeyboardButtonRow) {
            return (ImmutableKeyboardButtonRow)instance;
        }
        return ImmutableKeyboardButtonRow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<KeyboardButton> buttons = new ArrayList<KeyboardButton>();

        private Builder() {
        }

        public final Builder from(KeyboardButtonRow instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            KeyboardButtonRow instance;
            long bits = 0L;
            if (object instanceof KeyboardButtonRow) {
                instance = (KeyboardButtonRow)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllButtons(instance.buttons());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addButton(KeyboardButton element) {
            this.buttons.add(Objects.requireNonNull(element, "buttons element"));
            return this;
        }

        public final Builder addButtons(KeyboardButton ... elements) {
            for (KeyboardButton element : elements) {
                this.buttons.add(Objects.requireNonNull(element, "buttons element"));
            }
            return this;
        }

        public final Builder buttons(Iterable<? extends KeyboardButton> elements) {
            this.buttons.clear();
            return this.addAllButtons(elements);
        }

        public final Builder addAllButtons(Iterable<? extends KeyboardButton> elements) {
            for (KeyboardButton keyboardButton : elements) {
                this.buttons.add(Objects.requireNonNull(keyboardButton, "buttons element"));
            }
            return this;
        }

        public ImmutableKeyboardButtonRow build() {
            return new ImmutableKeyboardButtonRow(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

