/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.KeyboardButtonSwitchInline;
import telegram4j.tl.api.TlObject;

public final class ImmutableKeyboardButtonSwitchInline
implements KeyboardButtonSwitchInline {
    private final int identifier;
    private final int flags;
    private final boolean samePeer;
    private final String text;
    private final String query;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKeyboardButtonSwitchInline(String text, String query) {
        this.text = Objects.requireNonNull(text, "text");
        this.query = Objects.requireNonNull(query, "query");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.samePeer = this.initShim.samePeer();
        this.initShim = null;
    }

    private ImmutableKeyboardButtonSwitchInline(Builder builder) {
        this.text = builder.text;
        this.query = builder.query;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.samePeerIsSet()) {
            this.initShim.samePeer(builder.samePeer);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.samePeer = this.initShim.samePeer();
        this.initShim = null;
    }

    private ImmutableKeyboardButtonSwitchInline(int identifier, int flags, boolean samePeer, String text, String query) {
        this.identifier = identifier;
        this.flags = flags;
        this.samePeer = samePeer;
        this.text = text;
        this.query = query;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return KeyboardButtonSwitchInline.super.identifier();
    }

    private int flagsInitialize() {
        return KeyboardButtonSwitchInline.super.flags();
    }

    private boolean samePeerInitialize() {
        return KeyboardButtonSwitchInline.super.samePeer();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean samePeer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.samePeer() : this.samePeer;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public String query() {
        return this.query;
    }

    public final ImmutableKeyboardButtonSwitchInline withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableKeyboardButtonSwitchInline(value, this.flags, this.samePeer, this.text, this.query);
    }

    public final ImmutableKeyboardButtonSwitchInline withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableKeyboardButtonSwitchInline(this.identifier, value, this.samePeer, this.text, this.query);
    }

    public final ImmutableKeyboardButtonSwitchInline withSamePeer(boolean value) {
        if (this.samePeer == value) {
            return this;
        }
        return new ImmutableKeyboardButtonSwitchInline(this.identifier, this.flags, value, this.text, this.query);
    }

    public final ImmutableKeyboardButtonSwitchInline withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonSwitchInline(this.identifier, this.flags, this.samePeer, newValue, this.query);
    }

    public final ImmutableKeyboardButtonSwitchInline withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (this.query.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonSwitchInline(this.identifier, this.flags, this.samePeer, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyboardButtonSwitchInline && this.equalTo(0, (ImmutableKeyboardButtonSwitchInline)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyboardButtonSwitchInline another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.samePeer == another.samePeer && this.text.equals(another.text) && this.query.equals(another.query);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.samePeer);
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.query.hashCode();
        return h;
    }

    public String toString() {
        return "KeyboardButtonSwitchInline{identifier=" + this.identifier + ", flags=" + this.flags + ", samePeer=" + this.samePeer + ", text=" + this.text + ", query=" + this.query + "}";
    }

    public static ImmutableKeyboardButtonSwitchInline of(String text, String query) {
        return new ImmutableKeyboardButtonSwitchInline(text, query);
    }

    public static ImmutableKeyboardButtonSwitchInline copyOf(KeyboardButtonSwitchInline instance) {
        if (instance instanceof ImmutableKeyboardButtonSwitchInline) {
            return (ImmutableKeyboardButtonSwitchInline)instance;
        }
        return ImmutableKeyboardButtonSwitchInline.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_QUERY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SAME_PEER = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean samePeer;
        private String text;
        private String query;

        private Builder() {
        }

        public final Builder from(KeyboardButtonSwitchInline instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            KeyboardButton instance;
            long bits = 0L;
            if (object instanceof KeyboardButtonSwitchInline) {
                instance = (KeyboardButtonSwitchInline)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.samePeer(instance.samePeer());
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
                this.query(instance.query());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder samePeer(boolean samePeer) {
            this.samePeer = samePeer;
            this.optBits |= 4L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder query(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableKeyboardButtonSwitchInline build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyboardButtonSwitchInline(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean samePeerIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build KeyboardButtonSwitchInline, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte samePeerBuildStage = 0;
        private boolean samePeer;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableKeyboardButtonSwitchInline.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableKeyboardButtonSwitchInline.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean samePeer() {
            if (this.samePeerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.samePeerBuildStage == 0) {
                this.samePeerBuildStage = (byte)-1;
                this.samePeer = ImmutableKeyboardButtonSwitchInline.this.samePeerInitialize();
                this.samePeerBuildStage = 1;
            }
            return this.samePeer;
        }

        void samePeer(boolean samePeer) {
            this.samePeer = samePeer;
            this.samePeerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.samePeerBuildStage == -1) {
                attributes.add("samePeer");
            }
            return "Cannot build KeyboardButtonSwitchInline, attribute initializers form cycle " + attributes;
        }
    }
}

