/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.KeyboardButtonUrlAuth;
import telegram4j.tl.api.TlObject;

public final class ImmutableKeyboardButtonUrlAuth
implements KeyboardButtonUrlAuth {
    private final int identifier;
    private final int flags;
    private final String text;
    @Nullable
    private final String fwdText;
    private final String url;
    private final int buttonId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKeyboardButtonUrlAuth(String text, String url, int buttonId) {
        this.text = Objects.requireNonNull(text, "text");
        this.url = Objects.requireNonNull(url, "url");
        this.buttonId = buttonId;
        this.fwdText = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableKeyboardButtonUrlAuth(Builder builder) {
        this.text = builder.text;
        this.fwdText = builder.fwdText;
        this.url = builder.url;
        this.buttonId = builder.buttonId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableKeyboardButtonUrlAuth(int identifier, int flags, String text, @Nullable String fwdText, String url, int buttonId) {
        this.identifier = identifier;
        this.flags = flags;
        this.text = text;
        this.fwdText = fwdText;
        this.url = url;
        this.buttonId = buttonId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return KeyboardButtonUrlAuth.super.identifier();
    }

    private int flagsInitialize() {
        return KeyboardButtonUrlAuth.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    @Nullable
    public String fwdText() {
        return this.fwdText;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public int buttonId() {
        return this.buttonId;
    }

    public final ImmutableKeyboardButtonUrlAuth withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableKeyboardButtonUrlAuth(value, this.flags, this.text, this.fwdText, this.url, this.buttonId);
    }

    public final ImmutableKeyboardButtonUrlAuth withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableKeyboardButtonUrlAuth(this.identifier, value, this.text, this.fwdText, this.url, this.buttonId);
    }

    public final ImmutableKeyboardButtonUrlAuth withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonUrlAuth(this.identifier, this.flags, newValue, this.fwdText, this.url, this.buttonId);
    }

    public final ImmutableKeyboardButtonUrlAuth withFwdText(@Nullable String value) {
        if (Objects.equals(this.fwdText, value)) {
            return this;
        }
        return new ImmutableKeyboardButtonUrlAuth(this.identifier, this.flags, this.text, value, this.url, this.buttonId);
    }

    public final ImmutableKeyboardButtonUrlAuth withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonUrlAuth(this.identifier, this.flags, this.text, this.fwdText, newValue, this.buttonId);
    }

    public final ImmutableKeyboardButtonUrlAuth withButtonId(int value) {
        if (this.buttonId == value) {
            return this;
        }
        return new ImmutableKeyboardButtonUrlAuth(this.identifier, this.flags, this.text, this.fwdText, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyboardButtonUrlAuth && this.equalTo(0, (ImmutableKeyboardButtonUrlAuth)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyboardButtonUrlAuth another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.text.equals(another.text) && Objects.equals(this.fwdText, another.fwdText) && this.url.equals(another.url) && this.buttonId == another.buttonId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + Objects.hashCode(this.fwdText);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.buttonId;
        return h;
    }

    public String toString() {
        return "KeyboardButtonUrlAuth{identifier=" + this.identifier + ", flags=" + this.flags + ", text=" + this.text + ", fwdText=" + this.fwdText + ", url=" + this.url + ", buttonId=" + this.buttonId + "}";
    }

    public static ImmutableKeyboardButtonUrlAuth of(String text, String url, int buttonId) {
        return new ImmutableKeyboardButtonUrlAuth(text, url, buttonId);
    }

    public static ImmutableKeyboardButtonUrlAuth copyOf(KeyboardButtonUrlAuth instance) {
        if (instance instanceof ImmutableKeyboardButtonUrlAuth) {
            return (ImmutableKeyboardButtonUrlAuth)instance;
        }
        return ImmutableKeyboardButtonUrlAuth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long INIT_BIT_BUTTON_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private String text;
        private String fwdText;
        private String url;
        private int buttonId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButtonUrlAuth instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButtonUrlAuth) {
                String fwdTextValue;
                instance = (KeyboardButtonUrlAuth)object;
                this.flags(instance.flags());
                this.buttonId(instance.buttonId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
                if ((fwdTextValue = instance.fwdText()) != null) {
                    this.fwdText(fwdTextValue);
                }
                this.url(instance.url());
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fwdText(@Nullable String fwdText) {
            this.fwdText = fwdText;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder buttonId(int buttonId) {
            this.buttonId = buttonId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableKeyboardButtonUrlAuth build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyboardButtonUrlAuth(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("buttonId");
            }
            return "Cannot build KeyboardButtonUrlAuth, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableKeyboardButtonUrlAuth.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableKeyboardButtonUrlAuth.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build KeyboardButtonUrlAuth, attribute initializers form cycle " + attributes;
        }
    }
}

