/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.KeyboardButtonUserProfile;
import telegram4j.tl.api.TlObject;

public final class ImmutableKeyboardButtonUserProfile
implements KeyboardButtonUserProfile {
    private final int identifier;
    private final String text;
    private final long userId;

    private ImmutableKeyboardButtonUserProfile(String text, long userId) {
        this.text = Objects.requireNonNull(text, "text");
        this.userId = userId;
        this.identifier = KeyboardButtonUserProfile.super.identifier();
    }

    private ImmutableKeyboardButtonUserProfile(Builder builder) {
        this.text = builder.text;
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : KeyboardButtonUserProfile.super.identifier();
    }

    private ImmutableKeyboardButtonUserProfile(int identifier, String text, long userId) {
        this.identifier = identifier;
        this.text = text;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    public final ImmutableKeyboardButtonUserProfile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableKeyboardButtonUserProfile(value, this.text, this.userId);
    }

    public final ImmutableKeyboardButtonUserProfile withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonUserProfile(this.identifier, newValue, this.userId);
    }

    public final ImmutableKeyboardButtonUserProfile withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableKeyboardButtonUserProfile(this.identifier, this.text, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyboardButtonUserProfile && this.equalTo(0, (ImmutableKeyboardButtonUserProfile)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyboardButtonUserProfile another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.userId == another.userId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + Long.hashCode(this.userId);
        return h;
    }

    public String toString() {
        return "KeyboardButtonUserProfile{identifier=" + this.identifier + ", text=" + this.text + ", userId=" + this.userId + "}";
    }

    public static ImmutableKeyboardButtonUserProfile of(String text, long userId) {
        return new ImmutableKeyboardButtonUserProfile(text, userId);
    }

    public static ImmutableKeyboardButtonUserProfile copyOf(KeyboardButtonUserProfile instance) {
        if (instance instanceof ImmutableKeyboardButtonUserProfile) {
            return (ImmutableKeyboardButtonUserProfile)instance;
        }
        return ImmutableKeyboardButtonUserProfile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String text;
        private long userId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButtonUserProfile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButtonUserProfile) {
                instance = (KeyboardButtonUserProfile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableKeyboardButtonUserProfile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyboardButtonUserProfile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build KeyboardButtonUserProfile, some of required attributes are not set " + attributes;
        }
    }
}

