/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.KeyboardButtonWebView;
import telegram4j.tl.api.TlObject;

public final class ImmutableKeyboardButtonWebView
implements KeyboardButtonWebView {
    private final int identifier;
    private final String text;
    private final String url;

    private ImmutableKeyboardButtonWebView(String text, String url) {
        this.text = Objects.requireNonNull(text, "text");
        this.url = Objects.requireNonNull(url, "url");
        this.identifier = KeyboardButtonWebView.super.identifier();
    }

    private ImmutableKeyboardButtonWebView(Builder builder) {
        this.text = builder.text;
        this.url = builder.url;
        this.identifier = builder.identifierIsSet() ? builder.identifier : KeyboardButtonWebView.super.identifier();
    }

    private ImmutableKeyboardButtonWebView(int identifier, String text, String url) {
        this.identifier = identifier;
        this.text = text;
        this.url = url;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public String url() {
        return this.url;
    }

    public final ImmutableKeyboardButtonWebView withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableKeyboardButtonWebView(value, this.text, this.url);
    }

    public final ImmutableKeyboardButtonWebView withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonWebView(this.identifier, newValue, this.url);
    }

    public final ImmutableKeyboardButtonWebView withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonWebView(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyboardButtonWebView && this.equalTo(0, (ImmutableKeyboardButtonWebView)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyboardButtonWebView another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "KeyboardButtonWebView{identifier=" + this.identifier + ", text=" + this.text + ", url=" + this.url + "}";
    }

    public static ImmutableKeyboardButtonWebView of(String text, String url) {
        return new ImmutableKeyboardButtonWebView(text, url);
    }

    public static ImmutableKeyboardButtonWebView copyOf(KeyboardButtonWebView instance) {
        if (instance instanceof ImmutableKeyboardButtonWebView) {
            return (ImmutableKeyboardButtonWebView)instance;
        }
        return ImmutableKeyboardButtonWebView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String text;
        private String url;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButtonWebView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButtonWebView) {
                instance = (KeyboardButtonWebView)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.url(instance.url());
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableKeyboardButtonWebView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyboardButtonWebView(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build KeyboardButtonWebView, some of required attributes are not set " + attributes;
        }
    }
}

