/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.LabeledPrice;
import telegram4j.tl.api.TlObject;

public final class ImmutableLabeledPrice
implements LabeledPrice {
    private final int identifier;
    private final String label;
    private final long amount;

    private ImmutableLabeledPrice(String label, long amount) {
        this.label = Objects.requireNonNull(label, "label");
        this.amount = amount;
        this.identifier = LabeledPrice.super.identifier();
    }

    private ImmutableLabeledPrice(Builder builder) {
        this.label = builder.label;
        this.amount = builder.amount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : LabeledPrice.super.identifier();
    }

    private ImmutableLabeledPrice(int identifier, String label, long amount) {
        this.identifier = identifier;
        this.label = label;
        this.amount = amount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public long amount() {
        return this.amount;
    }

    public final ImmutableLabeledPrice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLabeledPrice(value, this.label, this.amount);
    }

    public final ImmutableLabeledPrice withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutableLabeledPrice(this.identifier, newValue, this.amount);
    }

    public final ImmutableLabeledPrice withAmount(long value) {
        if (this.amount == value) {
            return this;
        }
        return new ImmutableLabeledPrice(this.identifier, this.label, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLabeledPrice && this.equalTo(0, (ImmutableLabeledPrice)another);
    }

    private boolean equalTo(int synthetic, ImmutableLabeledPrice another) {
        return this.identifier == another.identifier && this.label.equals(another.label) && this.amount == another.amount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + Long.hashCode(this.amount);
        return h;
    }

    public String toString() {
        return "LabeledPrice{identifier=" + this.identifier + ", label=" + this.label + ", amount=" + this.amount + "}";
    }

    public static ImmutableLabeledPrice of(String label, long amount) {
        return new ImmutableLabeledPrice(label, amount);
    }

    public static ImmutableLabeledPrice copyOf(LabeledPrice instance) {
        if (instance instanceof ImmutableLabeledPrice) {
            return (ImmutableLabeledPrice)instance;
        }
        return ImmutableLabeledPrice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String label;
        private long amount;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LabeledPrice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof LabeledPrice) {
                instance = (LabeledPrice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.amount(instance.amount());
                this.label(instance.label());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder amount(long amount) {
            this.amount = amount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLabeledPrice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLabeledPrice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            return "Cannot build LabeledPrice, some of required attributes are not set " + attributes;
        }
    }
}

