/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.LangPackLanguage;
import telegram4j.tl.api.TlObject;

public final class ImmutableLangPackLanguage
implements LangPackLanguage {
    private final int identifier;
    private final int flags;
    private final boolean official;
    private final boolean rtl;
    private final boolean beta;
    private final String name;
    private final String nativeName;
    private final String langCode;
    @Nullable
    private final String baseLangCode;
    private final String pluralCode;
    private final int stringsCount;
    private final int translatedCount;
    private final String translationsUrl;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLangPackLanguage(String name, String nativeName, String langCode, String pluralCode, int stringsCount, int translatedCount, String translationsUrl) {
        this.name = Objects.requireNonNull(name, "name");
        this.nativeName = Objects.requireNonNull(nativeName, "nativeName");
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.pluralCode = Objects.requireNonNull(pluralCode, "pluralCode");
        this.stringsCount = stringsCount;
        this.translatedCount = translatedCount;
        this.translationsUrl = Objects.requireNonNull(translationsUrl, "translationsUrl");
        this.baseLangCode = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.official = this.initShim.official();
        this.rtl = this.initShim.rtl();
        this.beta = this.initShim.beta();
        this.initShim = null;
    }

    private ImmutableLangPackLanguage(Builder builder) {
        this.name = builder.name;
        this.nativeName = builder.nativeName;
        this.langCode = builder.langCode;
        this.baseLangCode = builder.baseLangCode;
        this.pluralCode = builder.pluralCode;
        this.stringsCount = builder.stringsCount;
        this.translatedCount = builder.translatedCount;
        this.translationsUrl = builder.translationsUrl;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.officialIsSet()) {
            this.initShim.official(builder.official);
        }
        if (builder.rtlIsSet()) {
            this.initShim.rtl(builder.rtl);
        }
        if (builder.betaIsSet()) {
            this.initShim.beta(builder.beta);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.official = this.initShim.official();
        this.rtl = this.initShim.rtl();
        this.beta = this.initShim.beta();
        this.initShim = null;
    }

    private ImmutableLangPackLanguage(int identifier, int flags, boolean official, boolean rtl, boolean beta, String name, String nativeName, String langCode, @Nullable String baseLangCode, String pluralCode, int stringsCount, int translatedCount, String translationsUrl) {
        this.identifier = identifier;
        this.flags = flags;
        this.official = official;
        this.rtl = rtl;
        this.beta = beta;
        this.name = name;
        this.nativeName = nativeName;
        this.langCode = langCode;
        this.baseLangCode = baseLangCode;
        this.pluralCode = pluralCode;
        this.stringsCount = stringsCount;
        this.translatedCount = translatedCount;
        this.translationsUrl = translationsUrl;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return LangPackLanguage.super.identifier();
    }

    private int flagsInitialize() {
        return LangPackLanguage.super.flags();
    }

    private boolean officialInitialize() {
        return LangPackLanguage.super.official();
    }

    private boolean rtlInitialize() {
        return LangPackLanguage.super.rtl();
    }

    private boolean betaInitialize() {
        return LangPackLanguage.super.beta();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean official() {
        InitShim shim = this.initShim;
        return shim != null ? shim.official() : this.official;
    }

    @Override
    public boolean rtl() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rtl() : this.rtl;
    }

    @Override
    public boolean beta() {
        InitShim shim = this.initShim;
        return shim != null ? shim.beta() : this.beta;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String nativeName() {
        return this.nativeName;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    @Override
    @Nullable
    public String baseLangCode() {
        return this.baseLangCode;
    }

    @Override
    public String pluralCode() {
        return this.pluralCode;
    }

    @Override
    public int stringsCount() {
        return this.stringsCount;
    }

    @Override
    public int translatedCount() {
        return this.translatedCount;
    }

    @Override
    public String translationsUrl() {
        return this.translationsUrl;
    }

    public final ImmutableLangPackLanguage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLangPackLanguage(value, this.flags, this.official, this.rtl, this.beta, this.name, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, value, this.official, this.rtl, this.beta, this.name, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withOfficial(boolean value) {
        if (this.official == value) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, value, this.rtl, this.beta, this.name, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withRtl(boolean value) {
        if (this.rtl == value) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, value, this.beta, this.name, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withBeta(boolean value) {
        if (this.beta == value) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, value, this.name, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, this.beta, newValue, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withNativeName(String value) {
        String newValue = Objects.requireNonNull(value, "nativeName");
        if (this.nativeName.equals(newValue)) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, this.beta, this.name, newValue, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, this.beta, this.name, this.nativeName, newValue, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withBaseLangCode(@Nullable String value) {
        if (Objects.equals(this.baseLangCode, value)) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, this.beta, this.name, this.nativeName, this.langCode, value, this.pluralCode, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withPluralCode(String value) {
        String newValue = Objects.requireNonNull(value, "pluralCode");
        if (this.pluralCode.equals(newValue)) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, this.beta, this.name, this.nativeName, this.langCode, this.baseLangCode, newValue, this.stringsCount, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withStringsCount(int value) {
        if (this.stringsCount == value) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, this.beta, this.name, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, value, this.translatedCount, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withTranslatedCount(int value) {
        if (this.translatedCount == value) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, this.beta, this.name, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, value, this.translationsUrl);
    }

    public final ImmutableLangPackLanguage withTranslationsUrl(String value) {
        String newValue = Objects.requireNonNull(value, "translationsUrl");
        if (this.translationsUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableLangPackLanguage(this.identifier, this.flags, this.official, this.rtl, this.beta, this.name, this.nativeName, this.langCode, this.baseLangCode, this.pluralCode, this.stringsCount, this.translatedCount, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLangPackLanguage && this.equalTo(0, (ImmutableLangPackLanguage)another);
    }

    private boolean equalTo(int synthetic, ImmutableLangPackLanguage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.official == another.official && this.rtl == another.rtl && this.beta == another.beta && this.name.equals(another.name) && this.nativeName.equals(another.nativeName) && this.langCode.equals(another.langCode) && Objects.equals(this.baseLangCode, another.baseLangCode) && this.pluralCode.equals(another.pluralCode) && this.stringsCount == another.stringsCount && this.translatedCount == another.translatedCount && this.translationsUrl.equals(another.translationsUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.official);
        h += (h << 5) + Boolean.hashCode(this.rtl);
        h += (h << 5) + Boolean.hashCode(this.beta);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.nativeName.hashCode();
        h += (h << 5) + this.langCode.hashCode();
        h += (h << 5) + Objects.hashCode(this.baseLangCode);
        h += (h << 5) + this.pluralCode.hashCode();
        h += (h << 5) + this.stringsCount;
        h += (h << 5) + this.translatedCount;
        h += (h << 5) + this.translationsUrl.hashCode();
        return h;
    }

    public String toString() {
        return "LangPackLanguage{identifier=" + this.identifier + ", flags=" + this.flags + ", official=" + this.official + ", rtl=" + this.rtl + ", beta=" + this.beta + ", name=" + this.name + ", nativeName=" + this.nativeName + ", langCode=" + this.langCode + ", baseLangCode=" + this.baseLangCode + ", pluralCode=" + this.pluralCode + ", stringsCount=" + this.stringsCount + ", translatedCount=" + this.translatedCount + ", translationsUrl=" + this.translationsUrl + "}";
    }

    public static ImmutableLangPackLanguage of(String name, String nativeName, String langCode, String pluralCode, int stringsCount, int translatedCount, String translationsUrl) {
        return new ImmutableLangPackLanguage(name, nativeName, langCode, pluralCode, stringsCount, translatedCount, translationsUrl);
    }

    public static ImmutableLangPackLanguage copyOf(LangPackLanguage instance) {
        if (instance instanceof ImmutableLangPackLanguage) {
            return (ImmutableLangPackLanguage)instance;
        }
        return ImmutableLangPackLanguage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_NATIVE_NAME = 2L;
        private static final long INIT_BIT_LANG_CODE = 4L;
        private static final long INIT_BIT_PLURAL_CODE = 8L;
        private static final long INIT_BIT_STRINGS_COUNT = 16L;
        private static final long INIT_BIT_TRANSLATED_COUNT = 32L;
        private static final long INIT_BIT_TRANSLATIONS_URL = 64L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_OFFICIAL = 4L;
        private static final long OPT_BIT_RTL = 8L;
        private static final long OPT_BIT_BETA = 16L;
        private long initBits = 127L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean official;
        private boolean rtl;
        private boolean beta;
        private String name;
        private String nativeName;
        private String langCode;
        private String baseLangCode;
        private String pluralCode;
        private int stringsCount;
        private int translatedCount;
        private String translationsUrl;

        private Builder() {
        }

        public final Builder from(LangPackLanguage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LangPackLanguage instance;
            long bits = 0L;
            if (object instanceof LangPackLanguage) {
                instance = (LangPackLanguage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.nativeName(instance.nativeName());
                this.langCode(instance.langCode());
                this.flags(instance.flags());
                this.official(instance.official());
                this.rtl(instance.rtl());
                this.translatedCount(instance.translatedCount());
                String baseLangCodeValue = instance.baseLangCode();
                if (baseLangCodeValue != null) {
                    this.baseLangCode(baseLangCodeValue);
                }
                this.stringsCount(instance.stringsCount());
                this.name(instance.name());
                this.pluralCode(instance.pluralCode());
                this.translationsUrl(instance.translationsUrl());
                this.beta(instance.beta());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder official(boolean official) {
            this.official = official;
            this.optBits |= 4L;
            return this;
        }

        public final Builder rtl(boolean rtl) {
            this.rtl = rtl;
            this.optBits |= 8L;
            return this;
        }

        public final Builder beta(boolean beta) {
            this.beta = beta;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder nativeName(String nativeName) {
            this.nativeName = Objects.requireNonNull(nativeName, "nativeName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder baseLangCode(@Nullable String baseLangCode) {
            this.baseLangCode = baseLangCode;
            return this;
        }

        public final Builder pluralCode(String pluralCode) {
            this.pluralCode = Objects.requireNonNull(pluralCode, "pluralCode");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder stringsCount(int stringsCount) {
            this.stringsCount = stringsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder translatedCount(int translatedCount) {
            this.translatedCount = translatedCount;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder translationsUrl(String translationsUrl) {
            this.translationsUrl = Objects.requireNonNull(translationsUrl, "translationsUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableLangPackLanguage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLangPackLanguage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean officialIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean rtlIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean betaIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nativeName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("langCode");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("pluralCode");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("stringsCount");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("translatedCount");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("translationsUrl");
            }
            return "Cannot build LangPackLanguage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte officialBuildStage = 0;
        private boolean official;
        private byte rtlBuildStage = 0;
        private boolean rtl;
        private byte betaBuildStage = 0;
        private boolean beta;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableLangPackLanguage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableLangPackLanguage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean official() {
            if (this.officialBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.officialBuildStage == 0) {
                this.officialBuildStage = (byte)-1;
                this.official = ImmutableLangPackLanguage.this.officialInitialize();
                this.officialBuildStage = 1;
            }
            return this.official;
        }

        void official(boolean official) {
            this.official = official;
            this.officialBuildStage = 1;
        }

        boolean rtl() {
            if (this.rtlBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rtlBuildStage == 0) {
                this.rtlBuildStage = (byte)-1;
                this.rtl = ImmutableLangPackLanguage.this.rtlInitialize();
                this.rtlBuildStage = 1;
            }
            return this.rtl;
        }

        void rtl(boolean rtl) {
            this.rtl = rtl;
            this.rtlBuildStage = 1;
        }

        boolean beta() {
            if (this.betaBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.betaBuildStage == 0) {
                this.betaBuildStage = (byte)-1;
                this.beta = ImmutableLangPackLanguage.this.betaInitialize();
                this.betaBuildStage = 1;
            }
            return this.beta;
        }

        void beta(boolean beta) {
            this.beta = beta;
            this.betaBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.officialBuildStage == -1) {
                attributes.add("official");
            }
            if (this.rtlBuildStage == -1) {
                attributes.add("rtl");
            }
            if (this.betaBuildStage == -1) {
                attributes.add("beta");
            }
            return "Cannot build LangPackLanguage, attribute initializers form cycle " + attributes;
        }
    }
}

