/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.LangPackString;
import telegram4j.tl.LangPackStringDeleted;
import telegram4j.tl.api.TlObject;

public final class ImmutableLangPackStringDeleted
implements LangPackStringDeleted {
    private final int identifier;
    private final String key;

    private ImmutableLangPackStringDeleted(String key) {
        this.key = Objects.requireNonNull(key, "key");
        this.identifier = LangPackStringDeleted.super.identifier();
    }

    private ImmutableLangPackStringDeleted(Builder builder) {
        this.key = builder.key;
        this.identifier = builder.identifierIsSet() ? builder.identifier : LangPackStringDeleted.super.identifier();
    }

    private ImmutableLangPackStringDeleted(int identifier, String key) {
        this.identifier = identifier;
        this.key = key;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String key() {
        return this.key;
    }

    public final ImmutableLangPackStringDeleted withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLangPackStringDeleted(value, this.key);
    }

    public final ImmutableLangPackStringDeleted withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableLangPackStringDeleted(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLangPackStringDeleted && this.equalTo(0, (ImmutableLangPackStringDeleted)another);
    }

    private boolean equalTo(int synthetic, ImmutableLangPackStringDeleted another) {
        return this.identifier == another.identifier && this.key.equals(another.key);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.key.hashCode();
        return h;
    }

    public String toString() {
        return "LangPackStringDeleted{identifier=" + this.identifier + ", key=" + this.key + "}";
    }

    public static ImmutableLangPackStringDeleted of(String key) {
        return new ImmutableLangPackStringDeleted(key);
    }

    public static ImmutableLangPackStringDeleted copyOf(LangPackStringDeleted instance) {
        if (instance instanceof ImmutableLangPackStringDeleted) {
            return (ImmutableLangPackStringDeleted)instance;
        }
        return ImmutableLangPackStringDeleted.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String key;

        private Builder() {
        }

        public final Builder from(LangPackString instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LangPackStringDeleted instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LangPackString instance;
            long bits = 0L;
            if (object instanceof LangPackString) {
                instance = (LangPackString)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof LangPackStringDeleted) {
                instance = (LangPackStringDeleted)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableLangPackStringDeleted build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLangPackStringDeleted(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build LangPackStringDeleted, some of required attributes are not set " + attributes;
        }
    }
}

