/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.LangPackString;
import telegram4j.tl.LangPackStringPluralized;
import telegram4j.tl.api.TlObject;

public final class ImmutableLangPackStringPluralized
implements LangPackStringPluralized {
    private final int identifier;
    private final int flags;
    private final String key;
    @Nullable
    private final String zeroValue;
    @Nullable
    private final String oneValue;
    @Nullable
    private final String twoValue;
    @Nullable
    private final String fewValue;
    @Nullable
    private final String manyValue;
    private final String otherValue;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLangPackStringPluralized(String key, String otherValue) {
        this.key = Objects.requireNonNull(key, "key");
        this.otherValue = Objects.requireNonNull(otherValue, "otherValue");
        this.zeroValue = null;
        this.oneValue = null;
        this.twoValue = null;
        this.fewValue = null;
        this.manyValue = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableLangPackStringPluralized(Builder builder) {
        this.key = builder.key;
        this.zeroValue = builder.zeroValue;
        this.oneValue = builder.oneValue;
        this.twoValue = builder.twoValue;
        this.fewValue = builder.fewValue;
        this.manyValue = builder.manyValue;
        this.otherValue = builder.otherValue;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableLangPackStringPluralized(int identifier, int flags, String key, @Nullable String zeroValue, @Nullable String oneValue, @Nullable String twoValue, @Nullable String fewValue, @Nullable String manyValue, String otherValue) {
        this.identifier = identifier;
        this.flags = flags;
        this.key = key;
        this.zeroValue = zeroValue;
        this.oneValue = oneValue;
        this.twoValue = twoValue;
        this.fewValue = fewValue;
        this.manyValue = manyValue;
        this.otherValue = otherValue;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return LangPackStringPluralized.super.identifier();
    }

    private int flagsInitialize() {
        return LangPackStringPluralized.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    @Nullable
    public String zeroValue() {
        return this.zeroValue;
    }

    @Override
    @Nullable
    public String oneValue() {
        return this.oneValue;
    }

    @Override
    @Nullable
    public String twoValue() {
        return this.twoValue;
    }

    @Override
    @Nullable
    public String fewValue() {
        return this.fewValue;
    }

    @Override
    @Nullable
    public String manyValue() {
        return this.manyValue;
    }

    @Override
    public String otherValue() {
        return this.otherValue;
    }

    public final ImmutableLangPackStringPluralized withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(value, this.flags, this.key, this.zeroValue, this.oneValue, this.twoValue, this.fewValue, this.manyValue, this.otherValue);
    }

    public final ImmutableLangPackStringPluralized withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(this.identifier, value, this.key, this.zeroValue, this.oneValue, this.twoValue, this.fewValue, this.manyValue, this.otherValue);
    }

    public final ImmutableLangPackStringPluralized withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(this.identifier, this.flags, newValue, this.zeroValue, this.oneValue, this.twoValue, this.fewValue, this.manyValue, this.otherValue);
    }

    public final ImmutableLangPackStringPluralized withZeroValue(@Nullable String value) {
        if (Objects.equals(this.zeroValue, value)) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(this.identifier, this.flags, this.key, value, this.oneValue, this.twoValue, this.fewValue, this.manyValue, this.otherValue);
    }

    public final ImmutableLangPackStringPluralized withOneValue(@Nullable String value) {
        if (Objects.equals(this.oneValue, value)) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(this.identifier, this.flags, this.key, this.zeroValue, value, this.twoValue, this.fewValue, this.manyValue, this.otherValue);
    }

    public final ImmutableLangPackStringPluralized withTwoValue(@Nullable String value) {
        if (Objects.equals(this.twoValue, value)) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(this.identifier, this.flags, this.key, this.zeroValue, this.oneValue, value, this.fewValue, this.manyValue, this.otherValue);
    }

    public final ImmutableLangPackStringPluralized withFewValue(@Nullable String value) {
        if (Objects.equals(this.fewValue, value)) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(this.identifier, this.flags, this.key, this.zeroValue, this.oneValue, this.twoValue, value, this.manyValue, this.otherValue);
    }

    public final ImmutableLangPackStringPluralized withManyValue(@Nullable String value) {
        if (Objects.equals(this.manyValue, value)) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(this.identifier, this.flags, this.key, this.zeroValue, this.oneValue, this.twoValue, this.fewValue, value, this.otherValue);
    }

    public final ImmutableLangPackStringPluralized withOtherValue(String value) {
        String newValue = Objects.requireNonNull(value, "otherValue");
        if (this.otherValue.equals(newValue)) {
            return this;
        }
        return new ImmutableLangPackStringPluralized(this.identifier, this.flags, this.key, this.zeroValue, this.oneValue, this.twoValue, this.fewValue, this.manyValue, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLangPackStringPluralized && this.equalTo(0, (ImmutableLangPackStringPluralized)another);
    }

    private boolean equalTo(int synthetic, ImmutableLangPackStringPluralized another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.key.equals(another.key) && Objects.equals(this.zeroValue, another.zeroValue) && Objects.equals(this.oneValue, another.oneValue) && Objects.equals(this.twoValue, another.twoValue) && Objects.equals(this.fewValue, another.fewValue) && Objects.equals(this.manyValue, another.manyValue) && this.otherValue.equals(another.otherValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.zeroValue);
        h += (h << 5) + Objects.hashCode(this.oneValue);
        h += (h << 5) + Objects.hashCode(this.twoValue);
        h += (h << 5) + Objects.hashCode(this.fewValue);
        h += (h << 5) + Objects.hashCode(this.manyValue);
        h += (h << 5) + this.otherValue.hashCode();
        return h;
    }

    public String toString() {
        return "LangPackStringPluralized{identifier=" + this.identifier + ", flags=" + this.flags + ", key=" + this.key + ", zeroValue=" + this.zeroValue + ", oneValue=" + this.oneValue + ", twoValue=" + this.twoValue + ", fewValue=" + this.fewValue + ", manyValue=" + this.manyValue + ", otherValue=" + this.otherValue + "}";
    }

    public static ImmutableLangPackStringPluralized of(String key, String otherValue) {
        return new ImmutableLangPackStringPluralized(key, otherValue);
    }

    public static ImmutableLangPackStringPluralized copyOf(LangPackStringPluralized instance) {
        if (instance instanceof ImmutableLangPackStringPluralized) {
            return (ImmutableLangPackStringPluralized)instance;
        }
        return ImmutableLangPackStringPluralized.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_OTHER_VALUE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private String key;
        private String zeroValue;
        private String oneValue;
        private String twoValue;
        private String fewValue;
        private String manyValue;
        private String otherValue;

        private Builder() {
        }

        public final Builder from(LangPackString instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LangPackStringPluralized instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LangPackString instance;
            long bits = 0L;
            if (object instanceof LangPackString) {
                instance = (LangPackString)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
            }
            if (object instanceof LangPackStringPluralized) {
                String fewValueValue;
                String manyValueValue;
                String twoValueValue;
                String zeroValueValue;
                instance = (LangPackStringPluralized)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((zeroValueValue = instance.zeroValue()) != null) {
                    this.zeroValue(zeroValueValue);
                }
                if ((twoValueValue = instance.twoValue()) != null) {
                    this.twoValue(twoValueValue);
                }
                if ((manyValueValue = instance.manyValue()) != null) {
                    this.manyValue(manyValueValue);
                }
                this.flags(instance.flags());
                String oneValueValue = instance.oneValue();
                if (oneValueValue != null) {
                    this.oneValue(oneValueValue);
                }
                this.otherValue(instance.otherValue());
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
                if ((fewValueValue = instance.fewValue()) != null) {
                    this.fewValue(fewValueValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder zeroValue(@Nullable String zeroValue) {
            this.zeroValue = zeroValue;
            return this;
        }

        public final Builder oneValue(@Nullable String oneValue) {
            this.oneValue = oneValue;
            return this;
        }

        public final Builder twoValue(@Nullable String twoValue) {
            this.twoValue = twoValue;
            return this;
        }

        public final Builder fewValue(@Nullable String fewValue) {
            this.fewValue = fewValue;
            return this;
        }

        public final Builder manyValue(@Nullable String manyValue) {
            this.manyValue = manyValue;
            return this;
        }

        public final Builder otherValue(String otherValue) {
            this.otherValue = Objects.requireNonNull(otherValue, "otherValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLangPackStringPluralized build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLangPackStringPluralized(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("otherValue");
            }
            return "Cannot build LangPackStringPluralized, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableLangPackStringPluralized.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableLangPackStringPluralized.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build LangPackStringPluralized, attribute initializers form cycle " + attributes;
        }
    }
}

