/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MaskCoords;
import telegram4j.tl.api.TlObject;

public final class ImmutableMaskCoords
implements MaskCoords {
    private final int identifier;
    private final int n;
    private final double x;
    private final double y;
    private final double zoom;

    private ImmutableMaskCoords(int n, double x, double y, double zoom) {
        this.n = n;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
        this.identifier = MaskCoords.super.identifier();
    }

    private ImmutableMaskCoords(Builder builder) {
        this.n = builder.n;
        this.x = builder.x;
        this.y = builder.y;
        this.zoom = builder.zoom;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MaskCoords.super.identifier();
    }

    private ImmutableMaskCoords(int identifier, int n, double x, double y, double zoom) {
        this.identifier = identifier;
        this.n = n;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int n() {
        return this.n;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double zoom() {
        return this.zoom;
    }

    public final ImmutableMaskCoords withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMaskCoords(value, this.n, this.x, this.y, this.zoom);
    }

    public final ImmutableMaskCoords withN(int value) {
        if (this.n == value) {
            return this;
        }
        return new ImmutableMaskCoords(this.identifier, value, this.x, this.y, this.zoom);
    }

    public final ImmutableMaskCoords withX(double value) {
        if (Double.doubleToLongBits(this.x) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableMaskCoords(this.identifier, this.n, value, this.y, this.zoom);
    }

    public final ImmutableMaskCoords withY(double value) {
        if (Double.doubleToLongBits(this.y) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableMaskCoords(this.identifier, this.n, this.x, value, this.zoom);
    }

    public final ImmutableMaskCoords withZoom(double value) {
        if (Double.doubleToLongBits(this.zoom) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableMaskCoords(this.identifier, this.n, this.x, this.y, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMaskCoords && this.equalTo(0, (ImmutableMaskCoords)another);
    }

    private boolean equalTo(int synthetic, ImmutableMaskCoords another) {
        return this.identifier == another.identifier && this.n == another.n && Double.doubleToLongBits(this.x) == Double.doubleToLongBits(another.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(another.y) && Double.doubleToLongBits(this.zoom) == Double.doubleToLongBits(another.zoom);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.n;
        h += (h << 5) + Double.hashCode(this.x);
        h += (h << 5) + Double.hashCode(this.y);
        h += (h << 5) + Double.hashCode(this.zoom);
        return h;
    }

    public String toString() {
        return "MaskCoords{identifier=" + this.identifier + ", n=" + this.n + ", x=" + this.x + ", y=" + this.y + ", zoom=" + this.zoom + "}";
    }

    public static ImmutableMaskCoords of(int n, double x, double y, double zoom) {
        return new ImmutableMaskCoords(n, x, y, zoom);
    }

    public static ImmutableMaskCoords copyOf(MaskCoords instance) {
        if (instance instanceof ImmutableMaskCoords) {
            return (ImmutableMaskCoords)instance;
        }
        return ImmutableMaskCoords.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_N = 1L;
        private static final long INIT_BIT_X = 2L;
        private static final long INIT_BIT_Y = 4L;
        private static final long INIT_BIT_ZOOM = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int n;
        private double x;
        private double y;
        private double zoom;

        private Builder() {
        }

        public final Builder from(MaskCoords instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MaskCoords instance;
            long bits = 0L;
            if (object instanceof MaskCoords) {
                instance = (MaskCoords)object;
                this.x(instance.x());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.y(instance.y());
                this.zoom(instance.zoom());
                this.n(instance.n());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder n(int n) {
            this.n = n;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder x(double x) {
            this.x = x;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder y(double y) {
            this.y = y;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder zoom(double zoom) {
            this.zoom = zoom;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableMaskCoords build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMaskCoords(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("n");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("x");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("y");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("zoom");
            }
            return "Cannot build MaskCoords, some of required attributes are not set " + attributes;
        }
    }
}

