/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionBotAllowed;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionBotAllowed
implements MessageActionBotAllowed {
    private final int identifier;
    private final String domain;

    private ImmutableMessageActionBotAllowed(String domain) {
        this.domain = Objects.requireNonNull(domain, "domain");
        this.identifier = MessageActionBotAllowed.super.identifier();
    }

    private ImmutableMessageActionBotAllowed(Builder builder) {
        this.domain = builder.domain;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionBotAllowed.super.identifier();
    }

    private ImmutableMessageActionBotAllowed(int identifier, String domain) {
        this.identifier = identifier;
        this.domain = domain;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    public final ImmutableMessageActionBotAllowed withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionBotAllowed(value, this.domain);
    }

    public final ImmutableMessageActionBotAllowed withDomain(String value) {
        String newValue = Objects.requireNonNull(value, "domain");
        if (this.domain.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionBotAllowed(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionBotAllowed && this.equalTo(0, (ImmutableMessageActionBotAllowed)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionBotAllowed another) {
        return this.identifier == another.identifier && this.domain.equals(another.domain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.domain.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionBotAllowed{identifier=" + this.identifier + ", domain=" + this.domain + "}";
    }

    public static ImmutableMessageActionBotAllowed of(String domain) {
        return new ImmutableMessageActionBotAllowed(domain);
    }

    public static ImmutableMessageActionBotAllowed copyOf(MessageActionBotAllowed instance) {
        if (instance instanceof ImmutableMessageActionBotAllowed) {
            return (ImmutableMessageActionBotAllowed)instance;
        }
        return ImmutableMessageActionBotAllowed.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String domain;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionBotAllowed instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionBotAllowed) {
                instance = (MessageActionBotAllowed)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.domain(instance.domain());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageActionBotAllowed build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionBotAllowed(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domain");
            }
            return "Cannot build MessageActionBotAllowed, some of required attributes are not set " + attributes;
        }
    }
}

