/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionChannelMigrateFrom;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionChannelMigrateFrom
implements MessageActionChannelMigrateFrom {
    private final int identifier;
    private final String title;
    private final long chatId;

    private ImmutableMessageActionChannelMigrateFrom(String title, long chatId) {
        this.title = Objects.requireNonNull(title, "title");
        this.chatId = chatId;
        this.identifier = MessageActionChannelMigrateFrom.super.identifier();
    }

    private ImmutableMessageActionChannelMigrateFrom(Builder builder) {
        this.title = builder.title;
        this.chatId = builder.chatId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionChannelMigrateFrom.super.identifier();
    }

    private ImmutableMessageActionChannelMigrateFrom(int identifier, String title, long chatId) {
        this.identifier = identifier;
        this.title = title;
        this.chatId = chatId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    public final ImmutableMessageActionChannelMigrateFrom withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionChannelMigrateFrom(value, this.title, this.chatId);
    }

    public final ImmutableMessageActionChannelMigrateFrom withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionChannelMigrateFrom(this.identifier, newValue, this.chatId);
    }

    public final ImmutableMessageActionChannelMigrateFrom withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableMessageActionChannelMigrateFrom(this.identifier, this.title, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionChannelMigrateFrom && this.equalTo(0, (ImmutableMessageActionChannelMigrateFrom)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionChannelMigrateFrom another) {
        return this.identifier == another.identifier && this.title.equals(another.title) && this.chatId == another.chatId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Long.hashCode(this.chatId);
        return h;
    }

    public String toString() {
        return "MessageActionChannelMigrateFrom{identifier=" + this.identifier + ", title=" + this.title + ", chatId=" + this.chatId + "}";
    }

    public static ImmutableMessageActionChannelMigrateFrom of(String title, long chatId) {
        return new ImmutableMessageActionChannelMigrateFrom(title, chatId);
    }

    public static ImmutableMessageActionChannelMigrateFrom copyOf(MessageActionChannelMigrateFrom instance) {
        if (instance instanceof ImmutableMessageActionChannelMigrateFrom) {
            return (ImmutableMessageActionChannelMigrateFrom)instance;
        }
        return ImmutableMessageActionChannelMigrateFrom.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_CHAT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String title;
        private long chatId;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionChannelMigrateFrom instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionChannelMigrateFrom) {
                instance = (MessageActionChannelMigrateFrom)object;
                this.chatId(instance.chatId());
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageActionChannelMigrateFrom build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionChannelMigrateFrom(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build MessageActionChannelMigrateFrom, some of required attributes are not set " + attributes;
        }
    }
}

