/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionChatAddUser;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionChatAddUser
implements MessageActionChatAddUser {
    private final int identifier;
    private final List<Long> users;

    private ImmutableMessageActionChatAddUser(Builder builder) {
        this.users = ImmutableMessageActionChatAddUser.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionChatAddUser.super.identifier();
    }

    private ImmutableMessageActionChatAddUser(int identifier, List<Long> users) {
        this.identifier = identifier;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> users() {
        return this.users;
    }

    public final ImmutableMessageActionChatAddUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionChatAddUser(value, this.users);
    }

    public final ImmutableMessageActionChatAddUser withUsers(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableMessageActionChatAddUser.createUnmodifiableList(false, wrappedList);
        return new ImmutableMessageActionChatAddUser(this.identifier, newValue);
    }

    public final ImmutableMessageActionChatAddUser withUsers(Iterable<Long> elements) {
        if (this.users == elements) {
            return this;
        }
        List<Long> newValue = ImmutableMessageActionChatAddUser.createUnmodifiableList(false, ImmutableMessageActionChatAddUser.createSafeList(elements, true, false));
        return new ImmutableMessageActionChatAddUser(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionChatAddUser && this.equalTo(0, (ImmutableMessageActionChatAddUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionChatAddUser another) {
        return this.identifier == another.identifier && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionChatAddUser{identifier=" + this.identifier + ", users=" + this.users + "}";
    }

    public static ImmutableMessageActionChatAddUser copyOf(MessageActionChatAddUser instance) {
        if (instance instanceof ImmutableMessageActionChatAddUser) {
            return (ImmutableMessageActionChatAddUser)instance;
        }
        return ImmutableMessageActionChatAddUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Long> users = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionChatAddUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionChatAddUser) {
                instance = (MessageActionChatAddUser)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addUser(long element) {
            this.users.add(element);
            return this;
        }

        public final Builder addUsers(long ... elements) {
            for (long element : elements) {
                this.users.add(element);
            }
            return this;
        }

        public final Builder users(Iterable<Long> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<Long> elements) {
            for (Long element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public ImmutableMessageActionChatAddUser build() {
            return new ImmutableMessageActionChatAddUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

