/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionChatCreate;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionChatCreate
implements MessageActionChatCreate {
    private final int identifier;
    private final String title;
    private final List<Long> users;

    private ImmutableMessageActionChatCreate(String title) {
        this.title = Objects.requireNonNull(title, "title");
        this.users = Collections.emptyList();
        this.identifier = MessageActionChatCreate.super.identifier();
    }

    private ImmutableMessageActionChatCreate(Builder builder) {
        this.title = builder.title;
        this.users = ImmutableMessageActionChatCreate.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionChatCreate.super.identifier();
    }

    private ImmutableMessageActionChatCreate(int identifier, String title, List<Long> users) {
        this.identifier = identifier;
        this.title = title;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public List<Long> users() {
        return this.users;
    }

    public final ImmutableMessageActionChatCreate withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionChatCreate(value, this.title, this.users);
    }

    public final ImmutableMessageActionChatCreate withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionChatCreate(this.identifier, newValue, this.users);
    }

    public final ImmutableMessageActionChatCreate withUsers(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableMessageActionChatCreate.createUnmodifiableList(false, wrappedList);
        return new ImmutableMessageActionChatCreate(this.identifier, this.title, newValue);
    }

    public final ImmutableMessageActionChatCreate withUsers(Iterable<Long> elements) {
        if (this.users == elements) {
            return this;
        }
        List<Long> newValue = ImmutableMessageActionChatCreate.createUnmodifiableList(false, ImmutableMessageActionChatCreate.createSafeList(elements, true, false));
        return new ImmutableMessageActionChatCreate(this.identifier, this.title, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionChatCreate && this.equalTo(0, (ImmutableMessageActionChatCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionChatCreate another) {
        return this.identifier == another.identifier && this.title.equals(another.title) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionChatCreate{identifier=" + this.identifier + ", title=" + this.title + ", users=" + this.users + "}";
    }

    public static ImmutableMessageActionChatCreate of(String title) {
        return new ImmutableMessageActionChatCreate(title);
    }

    public static ImmutableMessageActionChatCreate copyOf(MessageActionChatCreate instance) {
        if (instance instanceof ImmutableMessageActionChatCreate) {
            return (ImmutableMessageActionChatCreate)instance;
        }
        return ImmutableMessageActionChatCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String title;
        private List<Long> users = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(MessageActionChatCreate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageActionChatCreate) {
                instance = (MessageActionChatCreate)object;
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUser(long element) {
            this.users.add(element);
            return this;
        }

        public final Builder addUsers(long ... elements) {
            for (long element : elements) {
                this.users.add(element);
            }
            return this;
        }

        public final Builder users(Iterable<Long> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<Long> elements) {
            for (Long element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public ImmutableMessageActionChatCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionChatCreate(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build MessageActionChatCreate, some of required attributes are not set " + attributes;
        }
    }
}

