/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionChatEditPhoto;
import telegram4j.tl.Photo;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionChatEditPhoto
implements MessageActionChatEditPhoto {
    private final int identifier;
    private final Photo photo;

    private ImmutableMessageActionChatEditPhoto(Photo photo) {
        this.photo = Objects.requireNonNull(photo, "photo");
        this.identifier = MessageActionChatEditPhoto.super.identifier();
    }

    private ImmutableMessageActionChatEditPhoto(Builder builder) {
        this.photo = builder.photo;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionChatEditPhoto.super.identifier();
    }

    private ImmutableMessageActionChatEditPhoto(int identifier, Photo photo) {
        this.identifier = identifier;
        this.photo = photo;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Photo photo() {
        return this.photo;
    }

    public final ImmutableMessageActionChatEditPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionChatEditPhoto(value, this.photo);
    }

    public final ImmutableMessageActionChatEditPhoto withPhoto(Photo value) {
        if (this.photo == value) {
            return this;
        }
        Photo newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableMessageActionChatEditPhoto(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionChatEditPhoto && this.equalTo(0, (ImmutableMessageActionChatEditPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionChatEditPhoto another) {
        return this.identifier == another.identifier && this.photo.equals(another.photo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.photo.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionChatEditPhoto{identifier=" + this.identifier + ", photo=" + this.photo + "}";
    }

    public static ImmutableMessageActionChatEditPhoto of(Photo photo) {
        return new ImmutableMessageActionChatEditPhoto(photo);
    }

    public static ImmutableMessageActionChatEditPhoto copyOf(MessageActionChatEditPhoto instance) {
        if (instance instanceof ImmutableMessageActionChatEditPhoto) {
            return (ImmutableMessageActionChatEditPhoto)instance;
        }
        return ImmutableMessageActionChatEditPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHOTO = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Photo photo;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionChatEditPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionChatEditPhoto) {
                instance = (MessageActionChatEditPhoto)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.photo(instance.photo());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder photo(Photo photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageActionChatEditPhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionChatEditPhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("photo");
            }
            return "Cannot build MessageActionChatEditPhoto, some of required attributes are not set " + attributes;
        }
    }
}

