/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionChatEditTitle;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionChatEditTitle
implements MessageActionChatEditTitle {
    private final int identifier;
    private final String title;

    private ImmutableMessageActionChatEditTitle(String title) {
        this.title = Objects.requireNonNull(title, "title");
        this.identifier = MessageActionChatEditTitle.super.identifier();
    }

    private ImmutableMessageActionChatEditTitle(Builder builder) {
        this.title = builder.title;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionChatEditTitle.super.identifier();
    }

    private ImmutableMessageActionChatEditTitle(int identifier, String title) {
        this.identifier = identifier;
        this.title = title;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutableMessageActionChatEditTitle withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionChatEditTitle(value, this.title);
    }

    public final ImmutableMessageActionChatEditTitle withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionChatEditTitle(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionChatEditTitle && this.equalTo(0, (ImmutableMessageActionChatEditTitle)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionChatEditTitle another) {
        return this.identifier == another.identifier && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionChatEditTitle{identifier=" + this.identifier + ", title=" + this.title + "}";
    }

    public static ImmutableMessageActionChatEditTitle of(String title) {
        return new ImmutableMessageActionChatEditTitle(title);
    }

    public static ImmutableMessageActionChatEditTitle copyOf(MessageActionChatEditTitle instance) {
        if (instance instanceof ImmutableMessageActionChatEditTitle) {
            return (ImmutableMessageActionChatEditTitle)instance;
        }
        return ImmutableMessageActionChatEditTitle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String title;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionChatEditTitle instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionChatEditTitle) {
                instance = (MessageActionChatEditTitle)object;
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageActionChatEditTitle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionChatEditTitle(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build MessageActionChatEditTitle, some of required attributes are not set " + attributes;
        }
    }
}

