/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionChatJoinedByLink;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionChatJoinedByLink
implements MessageActionChatJoinedByLink {
    private final int identifier;
    private final long inviterId;

    private ImmutableMessageActionChatJoinedByLink(long inviterId) {
        this.inviterId = inviterId;
        this.identifier = MessageActionChatJoinedByLink.super.identifier();
    }

    private ImmutableMessageActionChatJoinedByLink(Builder builder) {
        this.inviterId = builder.inviterId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionChatJoinedByLink.super.identifier();
    }

    private ImmutableMessageActionChatJoinedByLink(int identifier, long inviterId) {
        this.identifier = identifier;
        this.inviterId = inviterId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long inviterId() {
        return this.inviterId;
    }

    public final ImmutableMessageActionChatJoinedByLink withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionChatJoinedByLink(value, this.inviterId);
    }

    public final ImmutableMessageActionChatJoinedByLink withInviterId(long value) {
        if (this.inviterId == value) {
            return this;
        }
        return new ImmutableMessageActionChatJoinedByLink(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionChatJoinedByLink && this.equalTo(0, (ImmutableMessageActionChatJoinedByLink)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionChatJoinedByLink another) {
        return this.identifier == another.identifier && this.inviterId == another.inviterId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.inviterId);
        return h;
    }

    public String toString() {
        return "MessageActionChatJoinedByLink{identifier=" + this.identifier + ", inviterId=" + this.inviterId + "}";
    }

    public static ImmutableMessageActionChatJoinedByLink of(long inviterId) {
        return new ImmutableMessageActionChatJoinedByLink(inviterId);
    }

    public static ImmutableMessageActionChatJoinedByLink copyOf(MessageActionChatJoinedByLink instance) {
        if (instance instanceof ImmutableMessageActionChatJoinedByLink) {
            return (ImmutableMessageActionChatJoinedByLink)instance;
        }
        return ImmutableMessageActionChatJoinedByLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INVITER_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long inviterId;

        private Builder() {
        }

        public final Builder from(MessageActionChatJoinedByLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageActionChatJoinedByLink) {
                instance = (MessageActionChatJoinedByLink)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.inviterId(instance.inviterId());
            }
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder inviterId(long inviterId) {
            this.inviterId = inviterId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageActionChatJoinedByLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionChatJoinedByLink(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("inviterId");
            }
            return "Cannot build MessageActionChatJoinedByLink, some of required attributes are not set " + attributes;
        }
    }
}

