/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionContactSignUp;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionContactSignUp
implements MessageActionContactSignUp {
    private final int identifier;
    private static final ImmutableMessageActionContactSignUp INSTANCE = ImmutableMessageActionContactSignUp.validate(new ImmutableMessageActionContactSignUp());

    private ImmutableMessageActionContactSignUp() {
        this.identifier = MessageActionContactSignUp.super.identifier();
    }

    private ImmutableMessageActionContactSignUp(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionContactSignUp.super.identifier();
    }

    private ImmutableMessageActionContactSignUp(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableMessageActionContactSignUp withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageActionContactSignUp.validate(new ImmutableMessageActionContactSignUp(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionContactSignUp && this.equalTo(0, (ImmutableMessageActionContactSignUp)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionContactSignUp another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "MessageActionContactSignUp{identifier=" + this.identifier + "}";
    }

    public static ImmutableMessageActionContactSignUp of() {
        return INSTANCE;
    }

    private static ImmutableMessageActionContactSignUp validate(ImmutableMessageActionContactSignUp instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageActionContactSignUp copyOf(MessageActionContactSignUp instance) {
        if (instance instanceof ImmutableMessageActionContactSignUp) {
            return (ImmutableMessageActionContactSignUp)instance;
        }
        return ImmutableMessageActionContactSignUp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionContactSignUp instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionContactSignUp) {
                instance = (MessageActionContactSignUp)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableMessageActionContactSignUp build() {
            return ImmutableMessageActionContactSignUp.validate(new ImmutableMessageActionContactSignUp(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

