/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionCustomAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionCustomAction
implements MessageActionCustomAction {
    private final int identifier;
    private final String message;

    private ImmutableMessageActionCustomAction(String message) {
        this.message = Objects.requireNonNull(message, "message");
        this.identifier = MessageActionCustomAction.super.identifier();
    }

    private ImmutableMessageActionCustomAction(Builder builder) {
        this.message = builder.message;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionCustomAction.super.identifier();
    }

    private ImmutableMessageActionCustomAction(int identifier, String message) {
        this.identifier = identifier;
        this.message = message;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String message() {
        return this.message;
    }

    public final ImmutableMessageActionCustomAction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionCustomAction(value, this.message);
    }

    public final ImmutableMessageActionCustomAction withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionCustomAction(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionCustomAction && this.equalTo(0, (ImmutableMessageActionCustomAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionCustomAction another) {
        return this.identifier == another.identifier && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionCustomAction{identifier=" + this.identifier + ", message=" + this.message + "}";
    }

    public static ImmutableMessageActionCustomAction of(String message) {
        return new ImmutableMessageActionCustomAction(message);
    }

    public static ImmutableMessageActionCustomAction copyOf(MessageActionCustomAction instance) {
        if (instance instanceof ImmutableMessageActionCustomAction) {
            return (ImmutableMessageActionCustomAction)instance;
        }
        return ImmutableMessageActionCustomAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String message;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionCustomAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionCustomAction) {
                instance = (MessageActionCustomAction)object;
                this.message(instance.message());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageActionCustomAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionCustomAction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build MessageActionCustomAction, some of required attributes are not set " + attributes;
        }
    }
}

