/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionEmpty
implements MessageActionEmpty {
    private final int identifier;
    private static final ImmutableMessageActionEmpty INSTANCE = ImmutableMessageActionEmpty.validate(new ImmutableMessageActionEmpty());

    private ImmutableMessageActionEmpty() {
        this.identifier = MessageActionEmpty.super.identifier();
    }

    private ImmutableMessageActionEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionEmpty.super.identifier();
    }

    private ImmutableMessageActionEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableMessageActionEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageActionEmpty.validate(new ImmutableMessageActionEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionEmpty && this.equalTo(0, (ImmutableMessageActionEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "MessageActionEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableMessageActionEmpty of() {
        return INSTANCE;
    }

    private static ImmutableMessageActionEmpty validate(ImmutableMessageActionEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageActionEmpty copyOf(MessageActionEmpty instance) {
        if (instance instanceof ImmutableMessageActionEmpty) {
            return (ImmutableMessageActionEmpty)instance;
        }
        return ImmutableMessageActionEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionEmpty) {
                instance = (MessageActionEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableMessageActionEmpty build() {
            return ImmutableMessageActionEmpty.validate(new ImmutableMessageActionEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

