/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionGameScore;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionGameScore
implements MessageActionGameScore {
    private final int identifier;
    private final long gameId;
    private final int score;

    private ImmutableMessageActionGameScore(long gameId, int score) {
        this.gameId = gameId;
        this.score = score;
        this.identifier = MessageActionGameScore.super.identifier();
    }

    private ImmutableMessageActionGameScore(Builder builder) {
        this.gameId = builder.gameId;
        this.score = builder.score;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionGameScore.super.identifier();
    }

    private ImmutableMessageActionGameScore(int identifier, long gameId, int score) {
        this.identifier = identifier;
        this.gameId = gameId;
        this.score = score;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long gameId() {
        return this.gameId;
    }

    @Override
    public int score() {
        return this.score;
    }

    public final ImmutableMessageActionGameScore withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionGameScore(value, this.gameId, this.score);
    }

    public final ImmutableMessageActionGameScore withGameId(long value) {
        if (this.gameId == value) {
            return this;
        }
        return new ImmutableMessageActionGameScore(this.identifier, value, this.score);
    }

    public final ImmutableMessageActionGameScore withScore(int value) {
        if (this.score == value) {
            return this;
        }
        return new ImmutableMessageActionGameScore(this.identifier, this.gameId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionGameScore && this.equalTo(0, (ImmutableMessageActionGameScore)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionGameScore another) {
        return this.identifier == another.identifier && this.gameId == another.gameId && this.score == another.score;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.gameId);
        h += (h << 5) + this.score;
        return h;
    }

    public String toString() {
        return "MessageActionGameScore{identifier=" + this.identifier + ", gameId=" + this.gameId + ", score=" + this.score + "}";
    }

    public static ImmutableMessageActionGameScore of(long gameId, int score) {
        return new ImmutableMessageActionGameScore(gameId, score);
    }

    public static ImmutableMessageActionGameScore copyOf(MessageActionGameScore instance) {
        if (instance instanceof ImmutableMessageActionGameScore) {
            return (ImmutableMessageActionGameScore)instance;
        }
        return ImmutableMessageActionGameScore.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GAME_ID = 1L;
        private static final long INIT_BIT_SCORE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long gameId;
        private int score;

        private Builder() {
        }

        public final Builder from(MessageActionGameScore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageActionGameScore) {
                instance = (MessageActionGameScore)object;
                this.gameId(instance.gameId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.score(instance.score());
            }
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder gameId(long gameId) {
            this.gameId = gameId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder score(int score) {
            this.score = score;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageActionGameScore build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionGameScore(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("gameId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("score");
            }
            return "Cannot build MessageActionGameScore, some of required attributes are not set " + attributes;
        }
    }
}

