/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionGeoProximityReached;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionGeoProximityReached
implements MessageActionGeoProximityReached {
    private final int identifier;
    private final Peer fromId;
    private final Peer toId;
    private final int distance;

    private ImmutableMessageActionGeoProximityReached(Peer fromId, Peer toId, int distance) {
        this.fromId = Objects.requireNonNull(fromId, "fromId");
        this.toId = Objects.requireNonNull(toId, "toId");
        this.distance = distance;
        this.identifier = MessageActionGeoProximityReached.super.identifier();
    }

    private ImmutableMessageActionGeoProximityReached(Builder builder) {
        this.fromId = builder.fromId;
        this.toId = builder.toId;
        this.distance = builder.distance;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionGeoProximityReached.super.identifier();
    }

    private ImmutableMessageActionGeoProximityReached(int identifier, Peer fromId, Peer toId, int distance) {
        this.identifier = identifier;
        this.fromId = fromId;
        this.toId = toId;
        this.distance = distance;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer fromId() {
        return this.fromId;
    }

    @Override
    public Peer toId() {
        return this.toId;
    }

    @Override
    public int distance() {
        return this.distance;
    }

    public final ImmutableMessageActionGeoProximityReached withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionGeoProximityReached(value, this.fromId, this.toId, this.distance);
    }

    public final ImmutableMessageActionGeoProximityReached withFromId(Peer value) {
        if (this.fromId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "fromId");
        return new ImmutableMessageActionGeoProximityReached(this.identifier, newValue, this.toId, this.distance);
    }

    public final ImmutableMessageActionGeoProximityReached withToId(Peer value) {
        if (this.toId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "toId");
        return new ImmutableMessageActionGeoProximityReached(this.identifier, this.fromId, newValue, this.distance);
    }

    public final ImmutableMessageActionGeoProximityReached withDistance(int value) {
        if (this.distance == value) {
            return this;
        }
        return new ImmutableMessageActionGeoProximityReached(this.identifier, this.fromId, this.toId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionGeoProximityReached && this.equalTo(0, (ImmutableMessageActionGeoProximityReached)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionGeoProximityReached another) {
        return this.identifier == another.identifier && this.fromId.equals(another.fromId) && this.toId.equals(another.toId) && this.distance == another.distance;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.fromId.hashCode();
        h += (h << 5) + this.toId.hashCode();
        h += (h << 5) + this.distance;
        return h;
    }

    public String toString() {
        return "MessageActionGeoProximityReached{identifier=" + this.identifier + ", fromId=" + this.fromId + ", toId=" + this.toId + ", distance=" + this.distance + "}";
    }

    public static ImmutableMessageActionGeoProximityReached of(Peer fromId, Peer toId, int distance) {
        return new ImmutableMessageActionGeoProximityReached(fromId, toId, distance);
    }

    public static ImmutableMessageActionGeoProximityReached copyOf(MessageActionGeoProximityReached instance) {
        if (instance instanceof ImmutableMessageActionGeoProximityReached) {
            return (ImmutableMessageActionGeoProximityReached)instance;
        }
        return ImmutableMessageActionGeoProximityReached.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FROM_ID = 1L;
        private static final long INIT_BIT_TO_ID = 2L;
        private static final long INIT_BIT_DISTANCE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private Peer fromId;
        private Peer toId;
        private int distance;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionGeoProximityReached instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionGeoProximityReached) {
                instance = (MessageActionGeoProximityReached)object;
                this.toId(instance.toId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.distance(instance.distance());
                this.fromId(instance.fromId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder fromId(Peer fromId) {
            this.fromId = Objects.requireNonNull(fromId, "fromId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder toId(Peer toId) {
            this.toId = Objects.requireNonNull(toId, "toId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder distance(int distance) {
            this.distance = distance;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMessageActionGeoProximityReached build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionGeoProximityReached(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fromId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("toId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("distance");
            }
            return "Cannot build MessageActionGeoProximityReached, some of required attributes are not set " + attributes;
        }
    }
}

