/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionGiftPremium;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionGiftPremium
implements MessageActionGiftPremium {
    private final int identifier;
    private final String currency;
    private final long amount;
    private final int months;

    private ImmutableMessageActionGiftPremium(String currency, long amount, int months) {
        this.currency = Objects.requireNonNull(currency, "currency");
        this.amount = amount;
        this.months = months;
        this.identifier = MessageActionGiftPremium.super.identifier();
    }

    private ImmutableMessageActionGiftPremium(Builder builder) {
        this.currency = builder.currency;
        this.amount = builder.amount;
        this.months = builder.months;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionGiftPremium.super.identifier();
    }

    private ImmutableMessageActionGiftPremium(int identifier, String currency, long amount, int months) {
        this.identifier = identifier;
        this.currency = currency;
        this.amount = amount;
        this.months = months;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long amount() {
        return this.amount;
    }

    @Override
    public int months() {
        return this.months;
    }

    public final ImmutableMessageActionGiftPremium withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionGiftPremium(value, this.currency, this.amount, this.months);
    }

    public final ImmutableMessageActionGiftPremium withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionGiftPremium(this.identifier, newValue, this.amount, this.months);
    }

    public final ImmutableMessageActionGiftPremium withAmount(long value) {
        if (this.amount == value) {
            return this;
        }
        return new ImmutableMessageActionGiftPremium(this.identifier, this.currency, value, this.months);
    }

    public final ImmutableMessageActionGiftPremium withMonths(int value) {
        if (this.months == value) {
            return this;
        }
        return new ImmutableMessageActionGiftPremium(this.identifier, this.currency, this.amount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionGiftPremium && this.equalTo(0, (ImmutableMessageActionGiftPremium)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionGiftPremium another) {
        return this.identifier == another.identifier && this.currency.equals(another.currency) && this.amount == another.amount && this.months == another.months;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.amount);
        h += (h << 5) + this.months;
        return h;
    }

    public String toString() {
        return "MessageActionGiftPremium{identifier=" + this.identifier + ", currency=" + this.currency + ", amount=" + this.amount + ", months=" + this.months + "}";
    }

    public static ImmutableMessageActionGiftPremium of(String currency, long amount, int months) {
        return new ImmutableMessageActionGiftPremium(currency, amount, months);
    }

    public static ImmutableMessageActionGiftPremium copyOf(MessageActionGiftPremium instance) {
        if (instance instanceof ImmutableMessageActionGiftPremium) {
            return (ImmutableMessageActionGiftPremium)instance;
        }
        return ImmutableMessageActionGiftPremium.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CURRENCY = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private static final long INIT_BIT_MONTHS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String currency;
        private long amount;
        private int months;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionGiftPremium instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionGiftPremium) {
                instance = (MessageActionGiftPremium)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.amount(instance.amount());
                this.currency(instance.currency());
                this.months(instance.months());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder amount(long amount) {
            this.amount = amount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder months(int months) {
            this.months = months;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMessageActionGiftPremium build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionGiftPremium(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("months");
            }
            return "Cannot build MessageActionGiftPremium, some of required attributes are not set " + attributes;
        }
    }
}

