/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionGroupCall;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionGroupCall
implements MessageActionGroupCall {
    private final int identifier;
    private final int flags;
    private final InputGroupCall call;
    @Nullable
    private final Integer duration;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageActionGroupCall(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.duration = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageActionGroupCall(Builder builder) {
        this.call = builder.call;
        this.duration = builder.duration;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageActionGroupCall(int identifier, int flags, InputGroupCall call, @Nullable Integer duration) {
        this.identifier = identifier;
        this.flags = flags;
        this.call = call;
        this.duration = duration;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageActionGroupCall.super.identifier();
    }

    private int flagsInitialize() {
        return MessageActionGroupCall.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    @Nullable
    public Integer duration() {
        return this.duration;
    }

    public final ImmutableMessageActionGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionGroupCall(value, this.flags, this.call, this.duration);
    }

    public final ImmutableMessageActionGroupCall withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageActionGroupCall(this.identifier, value, this.call, this.duration);
    }

    public final ImmutableMessageActionGroupCall withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableMessageActionGroupCall(this.identifier, this.flags, newValue, this.duration);
    }

    public final ImmutableMessageActionGroupCall withDuration(@Nullable Integer value) {
        if (Objects.equals(this.duration, value)) {
            return this;
        }
        return new ImmutableMessageActionGroupCall(this.identifier, this.flags, this.call, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionGroupCall && this.equalTo(0, (ImmutableMessageActionGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionGroupCall another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.call.equals(another.call) && Objects.equals(this.duration, another.duration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + Objects.hashCode(this.duration);
        return h;
    }

    public String toString() {
        return "MessageActionGroupCall{identifier=" + this.identifier + ", flags=" + this.flags + ", call=" + this.call + ", duration=" + this.duration + "}";
    }

    public static ImmutableMessageActionGroupCall of(InputGroupCall call) {
        return new ImmutableMessageActionGroupCall(call);
    }

    public static ImmutableMessageActionGroupCall copyOf(MessageActionGroupCall instance) {
        if (instance instanceof ImmutableMessageActionGroupCall) {
            return (ImmutableMessageActionGroupCall)instance;
        }
        return ImmutableMessageActionGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputGroupCall call;
        private Integer duration;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionGroupCall) {
                instance = (MessageActionGroupCall)object;
                this.call(instance.call());
                Integer durationValue = instance.duration();
                if (durationValue != null) {
                    this.duration(durationValue);
                }
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder duration(@Nullable Integer duration) {
            this.duration = duration;
            return this;
        }

        public ImmutableMessageActionGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build MessageActionGroupCall, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageActionGroupCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageActionGroupCall.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build MessageActionGroupCall, attribute initializers form cycle " + attributes;
        }
    }
}

