/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionGroupCallScheduled;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionGroupCallScheduled
implements MessageActionGroupCallScheduled {
    private final int identifier;
    private final InputGroupCall call;
    private final int scheduleDate;

    private ImmutableMessageActionGroupCallScheduled(InputGroupCall call, int scheduleDate) {
        this.call = Objects.requireNonNull(call, "call");
        this.scheduleDate = scheduleDate;
        this.identifier = MessageActionGroupCallScheduled.super.identifier();
    }

    private ImmutableMessageActionGroupCallScheduled(Builder builder) {
        this.call = builder.call;
        this.scheduleDate = builder.scheduleDate;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionGroupCallScheduled.super.identifier();
    }

    private ImmutableMessageActionGroupCallScheduled(int identifier, InputGroupCall call, int scheduleDate) {
        this.identifier = identifier;
        this.call = call;
        this.scheduleDate = scheduleDate;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public int scheduleDate() {
        return this.scheduleDate;
    }

    public final ImmutableMessageActionGroupCallScheduled withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionGroupCallScheduled(value, this.call, this.scheduleDate);
    }

    public final ImmutableMessageActionGroupCallScheduled withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableMessageActionGroupCallScheduled(this.identifier, newValue, this.scheduleDate);
    }

    public final ImmutableMessageActionGroupCallScheduled withScheduleDate(int value) {
        if (this.scheduleDate == value) {
            return this;
        }
        return new ImmutableMessageActionGroupCallScheduled(this.identifier, this.call, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionGroupCallScheduled && this.equalTo(0, (ImmutableMessageActionGroupCallScheduled)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionGroupCallScheduled another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.scheduleDate == another.scheduleDate;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.scheduleDate;
        return h;
    }

    public String toString() {
        return "MessageActionGroupCallScheduled{identifier=" + this.identifier + ", call=" + this.call + ", scheduleDate=" + this.scheduleDate + "}";
    }

    public static ImmutableMessageActionGroupCallScheduled of(InputGroupCall call, int scheduleDate) {
        return new ImmutableMessageActionGroupCallScheduled(call, scheduleDate);
    }

    public static ImmutableMessageActionGroupCallScheduled copyOf(MessageActionGroupCallScheduled instance) {
        if (instance instanceof ImmutableMessageActionGroupCallScheduled) {
            return (ImmutableMessageActionGroupCallScheduled)instance;
        }
        return ImmutableMessageActionGroupCallScheduled.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_SCHEDULE_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private int scheduleDate;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionGroupCallScheduled instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionGroupCallScheduled) {
                instance = (MessageActionGroupCallScheduled)object;
                this.call(instance.call());
                this.scheduleDate(instance.scheduleDate());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder scheduleDate(int scheduleDate) {
            this.scheduleDate = scheduleDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageActionGroupCallScheduled build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionGroupCallScheduled(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scheduleDate");
            }
            return "Cannot build MessageActionGroupCallScheduled, some of required attributes are not set " + attributes;
        }
    }
}

