/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionHistoryClear;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionHistoryClear
implements MessageActionHistoryClear {
    private final int identifier;
    private static final ImmutableMessageActionHistoryClear INSTANCE = ImmutableMessageActionHistoryClear.validate(new ImmutableMessageActionHistoryClear());

    private ImmutableMessageActionHistoryClear() {
        this.identifier = MessageActionHistoryClear.super.identifier();
    }

    private ImmutableMessageActionHistoryClear(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionHistoryClear.super.identifier();
    }

    private ImmutableMessageActionHistoryClear(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableMessageActionHistoryClear withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageActionHistoryClear.validate(new ImmutableMessageActionHistoryClear(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionHistoryClear && this.equalTo(0, (ImmutableMessageActionHistoryClear)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionHistoryClear another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "MessageActionHistoryClear{identifier=" + this.identifier + "}";
    }

    public static ImmutableMessageActionHistoryClear of() {
        return INSTANCE;
    }

    private static ImmutableMessageActionHistoryClear validate(ImmutableMessageActionHistoryClear instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageActionHistoryClear copyOf(MessageActionHistoryClear instance) {
        if (instance instanceof ImmutableMessageActionHistoryClear) {
            return (ImmutableMessageActionHistoryClear)instance;
        }
        return ImmutableMessageActionHistoryClear.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionHistoryClear instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionHistoryClear) {
                instance = (MessageActionHistoryClear)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableMessageActionHistoryClear build() {
            return ImmutableMessageActionHistoryClear.validate(new ImmutableMessageActionHistoryClear(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

