/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionInviteToGroupCall;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionInviteToGroupCall
implements MessageActionInviteToGroupCall {
    private final int identifier;
    private final InputGroupCall call;
    private final List<Long> users;

    private ImmutableMessageActionInviteToGroupCall(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.users = Collections.emptyList();
        this.identifier = MessageActionInviteToGroupCall.super.identifier();
    }

    private ImmutableMessageActionInviteToGroupCall(Builder builder) {
        this.call = builder.call;
        this.users = ImmutableMessageActionInviteToGroupCall.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionInviteToGroupCall.super.identifier();
    }

    private ImmutableMessageActionInviteToGroupCall(int identifier, InputGroupCall call, List<Long> users) {
        this.identifier = identifier;
        this.call = call;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public List<Long> users() {
        return this.users;
    }

    public final ImmutableMessageActionInviteToGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionInviteToGroupCall(value, this.call, this.users);
    }

    public final ImmutableMessageActionInviteToGroupCall withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableMessageActionInviteToGroupCall(this.identifier, newValue, this.users);
    }

    public final ImmutableMessageActionInviteToGroupCall withUsers(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableMessageActionInviteToGroupCall.createUnmodifiableList(false, wrappedList);
        return new ImmutableMessageActionInviteToGroupCall(this.identifier, this.call, newValue);
    }

    public final ImmutableMessageActionInviteToGroupCall withUsers(Iterable<Long> elements) {
        if (this.users == elements) {
            return this;
        }
        List<Long> newValue = ImmutableMessageActionInviteToGroupCall.createUnmodifiableList(false, ImmutableMessageActionInviteToGroupCall.createSafeList(elements, true, false));
        return new ImmutableMessageActionInviteToGroupCall(this.identifier, this.call, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionInviteToGroupCall && this.equalTo(0, (ImmutableMessageActionInviteToGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionInviteToGroupCall another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionInviteToGroupCall{identifier=" + this.identifier + ", call=" + this.call + ", users=" + this.users + "}";
    }

    public static ImmutableMessageActionInviteToGroupCall of(InputGroupCall call) {
        return new ImmutableMessageActionInviteToGroupCall(call);
    }

    public static ImmutableMessageActionInviteToGroupCall copyOf(MessageActionInviteToGroupCall instance) {
        if (instance instanceof ImmutableMessageActionInviteToGroupCall) {
            return (ImmutableMessageActionInviteToGroupCall)instance;
        }
        return ImmutableMessageActionInviteToGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private List<Long> users = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(MessageActionInviteToGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageActionInviteToGroupCall) {
                instance = (MessageActionInviteToGroupCall)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUser(long element) {
            this.users.add(element);
            return this;
        }

        public final Builder addUsers(long ... elements) {
            for (long element : elements) {
                this.users.add(element);
            }
            return this;
        }

        public final Builder users(Iterable<Long> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<Long> elements) {
            for (Long element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public ImmutableMessageActionInviteToGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionInviteToGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build MessageActionInviteToGroupCall, some of required attributes are not set " + attributes;
        }
    }
}

