/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionPaymentSent;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionPaymentSent
implements MessageActionPaymentSent {
    private final int identifier;
    private final int flags;
    private final boolean recurringInit;
    private final boolean recurringUsed;
    private final String currency;
    private final long totalAmount;
    @Nullable
    private final String invoiceSlug;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageActionPaymentSent(String currency, long totalAmount) {
        this.currency = Objects.requireNonNull(currency, "currency");
        this.totalAmount = totalAmount;
        this.invoiceSlug = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.recurringInit = this.initShim.recurringInit();
        this.recurringUsed = this.initShim.recurringUsed();
        this.initShim = null;
    }

    private ImmutableMessageActionPaymentSent(Builder builder) {
        this.currency = builder.currency;
        this.totalAmount = builder.totalAmount;
        this.invoiceSlug = builder.invoiceSlug;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.recurringInitIsSet()) {
            this.initShim.recurringInit(builder.recurringInit);
        }
        if (builder.recurringUsedIsSet()) {
            this.initShim.recurringUsed(builder.recurringUsed);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.recurringInit = this.initShim.recurringInit();
        this.recurringUsed = this.initShim.recurringUsed();
        this.initShim = null;
    }

    private ImmutableMessageActionPaymentSent(int identifier, int flags, boolean recurringInit, boolean recurringUsed, String currency, long totalAmount, @Nullable String invoiceSlug) {
        this.identifier = identifier;
        this.flags = flags;
        this.recurringInit = recurringInit;
        this.recurringUsed = recurringUsed;
        this.currency = currency;
        this.totalAmount = totalAmount;
        this.invoiceSlug = invoiceSlug;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageActionPaymentSent.super.identifier();
    }

    private int flagsInitialize() {
        return MessageActionPaymentSent.super.flags();
    }

    private boolean recurringInitInitialize() {
        return MessageActionPaymentSent.super.recurringInit();
    }

    private boolean recurringUsedInitialize() {
        return MessageActionPaymentSent.super.recurringUsed();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean recurringInit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.recurringInit() : this.recurringInit;
    }

    @Override
    public boolean recurringUsed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.recurringUsed() : this.recurringUsed;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long totalAmount() {
        return this.totalAmount;
    }

    @Override
    @Nullable
    public String invoiceSlug() {
        return this.invoiceSlug;
    }

    public final ImmutableMessageActionPaymentSent withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSent(value, this.flags, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, this.invoiceSlug);
    }

    public final ImmutableMessageActionPaymentSent withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSent(this.identifier, value, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, this.invoiceSlug);
    }

    public final ImmutableMessageActionPaymentSent withRecurringInit(boolean value) {
        if (this.recurringInit == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSent(this.identifier, this.flags, value, this.recurringUsed, this.currency, this.totalAmount, this.invoiceSlug);
    }

    public final ImmutableMessageActionPaymentSent withRecurringUsed(boolean value) {
        if (this.recurringUsed == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSent(this.identifier, this.flags, this.recurringInit, value, this.currency, this.totalAmount, this.invoiceSlug);
    }

    public final ImmutableMessageActionPaymentSent withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionPaymentSent(this.identifier, this.flags, this.recurringInit, this.recurringUsed, newValue, this.totalAmount, this.invoiceSlug);
    }

    public final ImmutableMessageActionPaymentSent withTotalAmount(long value) {
        if (this.totalAmount == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSent(this.identifier, this.flags, this.recurringInit, this.recurringUsed, this.currency, value, this.invoiceSlug);
    }

    public final ImmutableMessageActionPaymentSent withInvoiceSlug(@Nullable String value) {
        if (Objects.equals(this.invoiceSlug, value)) {
            return this;
        }
        return new ImmutableMessageActionPaymentSent(this.identifier, this.flags, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionPaymentSent && this.equalTo(0, (ImmutableMessageActionPaymentSent)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionPaymentSent another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.recurringInit == another.recurringInit && this.recurringUsed == another.recurringUsed && this.currency.equals(another.currency) && this.totalAmount == another.totalAmount && Objects.equals(this.invoiceSlug, another.invoiceSlug);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.recurringInit);
        h += (h << 5) + Boolean.hashCode(this.recurringUsed);
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.totalAmount);
        h += (h << 5) + Objects.hashCode(this.invoiceSlug);
        return h;
    }

    public String toString() {
        return "MessageActionPaymentSent{identifier=" + this.identifier + ", flags=" + this.flags + ", recurringInit=" + this.recurringInit + ", recurringUsed=" + this.recurringUsed + ", currency=" + this.currency + ", totalAmount=" + this.totalAmount + ", invoiceSlug=" + this.invoiceSlug + "}";
    }

    public static ImmutableMessageActionPaymentSent of(String currency, long totalAmount) {
        return new ImmutableMessageActionPaymentSent(currency, totalAmount);
    }

    public static ImmutableMessageActionPaymentSent copyOf(MessageActionPaymentSent instance) {
        if (instance instanceof ImmutableMessageActionPaymentSent) {
            return (ImmutableMessageActionPaymentSent)instance;
        }
        return ImmutableMessageActionPaymentSent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CURRENCY = 1L;
        private static final long INIT_BIT_TOTAL_AMOUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_RECURRING_INIT = 4L;
        private static final long OPT_BIT_RECURRING_USED = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean recurringInit;
        private boolean recurringUsed;
        private String currency;
        private long totalAmount;
        private String invoiceSlug;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionPaymentSent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionPaymentSent) {
                instance = (MessageActionPaymentSent)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.totalAmount(instance.totalAmount());
                String invoiceSlugValue = instance.invoiceSlug();
                if (invoiceSlugValue != null) {
                    this.invoiceSlug(invoiceSlugValue);
                }
                this.flags(instance.flags());
                this.currency(instance.currency());
                this.recurringUsed(instance.recurringUsed());
                this.recurringInit(instance.recurringInit());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder recurringInit(boolean recurringInit) {
            this.recurringInit = recurringInit;
            this.optBits |= 4L;
            return this;
        }

        public final Builder recurringUsed(boolean recurringUsed) {
            this.recurringUsed = recurringUsed;
            this.optBits |= 8L;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder totalAmount(long totalAmount) {
            this.totalAmount = totalAmount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder invoiceSlug(@Nullable String invoiceSlug) {
            this.invoiceSlug = invoiceSlug;
            return this;
        }

        public ImmutableMessageActionPaymentSent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionPaymentSent(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean recurringInitIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean recurringUsedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalAmount");
            }
            return "Cannot build MessageActionPaymentSent, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte recurringInitBuildStage = 0;
        private boolean recurringInit;
        private byte recurringUsedBuildStage = 0;
        private boolean recurringUsed;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageActionPaymentSent.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageActionPaymentSent.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean recurringInit() {
            if (this.recurringInitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recurringInitBuildStage == 0) {
                this.recurringInitBuildStage = (byte)-1;
                this.recurringInit = ImmutableMessageActionPaymentSent.this.recurringInitInitialize();
                this.recurringInitBuildStage = 1;
            }
            return this.recurringInit;
        }

        void recurringInit(boolean recurringInit) {
            this.recurringInit = recurringInit;
            this.recurringInitBuildStage = 1;
        }

        boolean recurringUsed() {
            if (this.recurringUsedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recurringUsedBuildStage == 0) {
                this.recurringUsedBuildStage = (byte)-1;
                this.recurringUsed = ImmutableMessageActionPaymentSent.this.recurringUsedInitialize();
                this.recurringUsedBuildStage = 1;
            }
            return this.recurringUsed;
        }

        void recurringUsed(boolean recurringUsed) {
            this.recurringUsed = recurringUsed;
            this.recurringUsedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.recurringInitBuildStage == -1) {
                attributes.add("recurringInit");
            }
            if (this.recurringUsedBuildStage == -1) {
                attributes.add("recurringUsed");
            }
            return "Cannot build MessageActionPaymentSent, attribute initializers form cycle " + attributes;
        }
    }
}

