/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionPaymentSentMe;
import telegram4j.tl.PaymentCharge;
import telegram4j.tl.PaymentRequestedInfo;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionPaymentSentMe
implements MessageActionPaymentSentMe {
    private final int identifier;
    private final int flags;
    private final boolean recurringInit;
    private final boolean recurringUsed;
    private final String currency;
    private final long totalAmount;
    private final ByteBuf payload;
    @Nullable
    private final PaymentRequestedInfo info;
    @Nullable
    private final String shippingOptionId;
    private final PaymentCharge charge;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageActionPaymentSentMe(String currency, long totalAmount, PaymentCharge charge) {
        this.currency = Objects.requireNonNull(currency, "currency");
        this.totalAmount = totalAmount;
        this.charge = Objects.requireNonNull(charge, "charge");
        this.payload = null;
        this.info = null;
        this.shippingOptionId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.recurringInit = this.initShim.recurringInit();
        this.recurringUsed = this.initShim.recurringUsed();
        this.initShim = null;
    }

    private ImmutableMessageActionPaymentSentMe(Builder builder) {
        this.currency = builder.currency;
        this.totalAmount = builder.totalAmount;
        this.payload = builder.payload_build();
        this.info = builder.info;
        this.shippingOptionId = builder.shippingOptionId;
        this.charge = builder.charge;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.recurringInitIsSet()) {
            this.initShim.recurringInit(builder.recurringInit);
        }
        if (builder.recurringUsedIsSet()) {
            this.initShim.recurringUsed(builder.recurringUsed);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.recurringInit = this.initShim.recurringInit();
        this.recurringUsed = this.initShim.recurringUsed();
        this.initShim = null;
    }

    private ImmutableMessageActionPaymentSentMe(int identifier, int flags, boolean recurringInit, boolean recurringUsed, String currency, long totalAmount, ByteBuf payload, @Nullable PaymentRequestedInfo info, @Nullable String shippingOptionId, PaymentCharge charge) {
        this.identifier = identifier;
        this.flags = flags;
        this.recurringInit = recurringInit;
        this.recurringUsed = recurringUsed;
        this.currency = currency;
        this.totalAmount = totalAmount;
        this.payload = payload;
        this.info = info;
        this.shippingOptionId = shippingOptionId;
        this.charge = charge;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageActionPaymentSentMe.super.identifier();
    }

    private int flagsInitialize() {
        return MessageActionPaymentSentMe.super.flags();
    }

    private boolean recurringInitInitialize() {
        return MessageActionPaymentSentMe.super.recurringInit();
    }

    private boolean recurringUsedInitialize() {
        return MessageActionPaymentSentMe.super.recurringUsed();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean recurringInit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.recurringInit() : this.recurringInit;
    }

    @Override
    public boolean recurringUsed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.recurringUsed() : this.recurringUsed;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long totalAmount() {
        return this.totalAmount;
    }

    @Override
    public ByteBuf payload() {
        return this.payload.duplicate();
    }

    @Override
    @Nullable
    public PaymentRequestedInfo info() {
        return this.info;
    }

    @Override
    @Nullable
    public String shippingOptionId() {
        return this.shippingOptionId;
    }

    @Override
    public PaymentCharge charge() {
        return this.charge;
    }

    public final ImmutableMessageActionPaymentSentMe withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(value, this.flags, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, this.payload, this.info, this.shippingOptionId, this.charge);
    }

    public final ImmutableMessageActionPaymentSentMe withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(this.identifier, value, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, this.payload, this.info, this.shippingOptionId, this.charge);
    }

    public final ImmutableMessageActionPaymentSentMe withRecurringInit(boolean value) {
        if (this.recurringInit == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(this.identifier, this.flags, value, this.recurringUsed, this.currency, this.totalAmount, this.payload, this.info, this.shippingOptionId, this.charge);
    }

    public final ImmutableMessageActionPaymentSentMe withRecurringUsed(boolean value) {
        if (this.recurringUsed == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(this.identifier, this.flags, this.recurringInit, value, this.currency, this.totalAmount, this.payload, this.info, this.shippingOptionId, this.charge);
    }

    public final ImmutableMessageActionPaymentSentMe withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(this.identifier, this.flags, this.recurringInit, this.recurringUsed, newValue, this.totalAmount, this.payload, this.info, this.shippingOptionId, this.charge);
    }

    public final ImmutableMessageActionPaymentSentMe withTotalAmount(long value) {
        if (this.totalAmount == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(this.identifier, this.flags, this.recurringInit, this.recurringUsed, this.currency, value, this.payload, this.info, this.shippingOptionId, this.charge);
    }

    public ImmutableMessageActionPaymentSentMe withPayload(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.payload == newValue) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(this.identifier, this.flags, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, newValue, this.info, this.shippingOptionId, this.charge);
    }

    public final ImmutableMessageActionPaymentSentMe withInfo(@Nullable PaymentRequestedInfo value) {
        if (this.info == value) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(this.identifier, this.flags, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, this.payload, value, this.shippingOptionId, this.charge);
    }

    public final ImmutableMessageActionPaymentSentMe withShippingOptionId(@Nullable String value) {
        if (Objects.equals(this.shippingOptionId, value)) {
            return this;
        }
        return new ImmutableMessageActionPaymentSentMe(this.identifier, this.flags, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, this.payload, this.info, value, this.charge);
    }

    public final ImmutableMessageActionPaymentSentMe withCharge(PaymentCharge value) {
        if (this.charge == value) {
            return this;
        }
        PaymentCharge newValue = Objects.requireNonNull(value, "charge");
        return new ImmutableMessageActionPaymentSentMe(this.identifier, this.flags, this.recurringInit, this.recurringUsed, this.currency, this.totalAmount, this.payload, this.info, this.shippingOptionId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionPaymentSentMe && this.equalTo(0, (ImmutableMessageActionPaymentSentMe)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionPaymentSentMe another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.recurringInit == another.recurringInit && this.recurringUsed == another.recurringUsed && this.currency.equals(another.currency) && this.totalAmount == another.totalAmount && this.payload().equals((Object)another.payload()) && Objects.equals(this.info, another.info) && Objects.equals(this.shippingOptionId, another.shippingOptionId) && this.charge.equals(another.charge);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.recurringInit);
        h += (h << 5) + Boolean.hashCode(this.recurringUsed);
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.totalAmount);
        h += (h << 5) + this.payload().hashCode();
        h += (h << 5) + Objects.hashCode(this.info);
        h += (h << 5) + Objects.hashCode(this.shippingOptionId);
        h += (h << 5) + this.charge.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionPaymentSentMe{identifier=" + this.identifier + ", flags=" + this.flags + ", recurringInit=" + this.recurringInit + ", recurringUsed=" + this.recurringUsed + ", currency=" + this.currency + ", totalAmount=" + this.totalAmount + ", payload=" + ByteBufUtil.hexDump((ByteBuf)this.payload) + ", info=" + this.info + ", shippingOptionId=" + this.shippingOptionId + ", charge=" + this.charge + "}";
    }

    public static ImmutableMessageActionPaymentSentMe of(String currency, long totalAmount, PaymentCharge charge) {
        return new ImmutableMessageActionPaymentSentMe(currency, totalAmount, charge);
    }

    public static ImmutableMessageActionPaymentSentMe copyOf(MessageActionPaymentSentMe instance) {
        if (instance instanceof ImmutableMessageActionPaymentSentMe) {
            return (ImmutableMessageActionPaymentSentMe)instance;
        }
        return ImmutableMessageActionPaymentSentMe.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CURRENCY = 1L;
        private static final long INIT_BIT_TOTAL_AMOUNT = 2L;
        private static final long INIT_BIT_CHARGE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_RECURRING_INIT = 4L;
        private static final long OPT_BIT_RECURRING_USED = 8L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf payload_value = null;
        private int identifier;
        private int flags;
        private boolean recurringInit;
        private boolean recurringUsed;
        private String currency;
        private long totalAmount;
        private PaymentRequestedInfo info;
        private String shippingOptionId;
        private PaymentCharge charge;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionPaymentSentMe instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionPaymentSentMe) {
                instance = (MessageActionPaymentSentMe)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.totalAmount(instance.totalAmount());
                this.charge(instance.charge());
                this.payload(instance.payload());
                this.flags(instance.flags());
                this.currency(instance.currency());
                String shippingOptionIdValue = instance.shippingOptionId();
                if (shippingOptionIdValue != null) {
                    this.shippingOptionId(shippingOptionIdValue);
                }
                this.recurringUsed(instance.recurringUsed());
                this.recurringInit(instance.recurringInit());
                PaymentRequestedInfo infoValue = instance.info();
                if (infoValue != null) {
                    this.info(infoValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder recurringInit(boolean recurringInit) {
            this.recurringInit = recurringInit;
            this.optBits |= 4L;
            return this;
        }

        public final Builder recurringUsed(boolean recurringUsed) {
            this.recurringUsed = recurringUsed;
            this.optBits |= 8L;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder totalAmount(long totalAmount) {
            this.totalAmount = totalAmount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder payload(ByteBuf value) {
            this.payload_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder info(@Nullable PaymentRequestedInfo info) {
            this.info = info;
            return this;
        }

        public final Builder shippingOptionId(@Nullable String shippingOptionId) {
            this.shippingOptionId = shippingOptionId;
            return this;
        }

        public final Builder charge(PaymentCharge charge) {
            this.charge = Objects.requireNonNull(charge, "charge");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMessageActionPaymentSentMe build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionPaymentSentMe(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean recurringInitIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean recurringUsedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalAmount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("charge");
            }
            return "Cannot build MessageActionPaymentSentMe, some of required attributes are not set " + attributes;
        }

        private ByteBuf payload_build() {
            return Objects.requireNonNull(this.payload_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte recurringInitBuildStage = 0;
        private boolean recurringInit;
        private byte recurringUsedBuildStage = 0;
        private boolean recurringUsed;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageActionPaymentSentMe.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageActionPaymentSentMe.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean recurringInit() {
            if (this.recurringInitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recurringInitBuildStage == 0) {
                this.recurringInitBuildStage = (byte)-1;
                this.recurringInit = ImmutableMessageActionPaymentSentMe.this.recurringInitInitialize();
                this.recurringInitBuildStage = 1;
            }
            return this.recurringInit;
        }

        void recurringInit(boolean recurringInit) {
            this.recurringInit = recurringInit;
            this.recurringInitBuildStage = 1;
        }

        boolean recurringUsed() {
            if (this.recurringUsedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recurringUsedBuildStage == 0) {
                this.recurringUsedBuildStage = (byte)-1;
                this.recurringUsed = ImmutableMessageActionPaymentSentMe.this.recurringUsedInitialize();
                this.recurringUsedBuildStage = 1;
            }
            return this.recurringUsed;
        }

        void recurringUsed(boolean recurringUsed) {
            this.recurringUsed = recurringUsed;
            this.recurringUsedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.recurringInitBuildStage == -1) {
                attributes.add("recurringInit");
            }
            if (this.recurringUsedBuildStage == -1) {
                attributes.add("recurringUsed");
            }
            return "Cannot build MessageActionPaymentSentMe, attribute initializers form cycle " + attributes;
        }
    }
}

