/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionPhoneCall;
import telegram4j.tl.PhoneCallDiscardReason;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionPhoneCall
implements MessageActionPhoneCall {
    private final int identifier;
    private final int flags;
    private final boolean video;
    private final long callId;
    @Nullable
    private final PhoneCallDiscardReason reason;
    @Nullable
    private final Integer duration;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageActionPhoneCall(long callId) {
        this.callId = callId;
        this.reason = null;
        this.duration = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableMessageActionPhoneCall(Builder builder) {
        this.callId = builder.callId;
        this.reason = builder.reason;
        this.duration = builder.duration;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.videoIsSet()) {
            this.initShim.video(builder.video);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableMessageActionPhoneCall(int identifier, int flags, boolean video, long callId, @Nullable PhoneCallDiscardReason reason, @Nullable Integer duration) {
        this.identifier = identifier;
        this.flags = flags;
        this.video = video;
        this.callId = callId;
        this.reason = reason;
        this.duration = duration;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageActionPhoneCall.super.identifier();
    }

    private int flagsInitialize() {
        return MessageActionPhoneCall.super.flags();
    }

    private boolean videoInitialize() {
        return MessageActionPhoneCall.super.video();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean video() {
        InitShim shim = this.initShim;
        return shim != null ? shim.video() : this.video;
    }

    @Override
    public long callId() {
        return this.callId;
    }

    @Override
    @Nullable
    public PhoneCallDiscardReason reason() {
        return this.reason;
    }

    @Override
    @Nullable
    public Integer duration() {
        return this.duration;
    }

    public final ImmutableMessageActionPhoneCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionPhoneCall(value, this.flags, this.video, this.callId, this.reason, this.duration);
    }

    public final ImmutableMessageActionPhoneCall withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageActionPhoneCall(this.identifier, value, this.video, this.callId, this.reason, this.duration);
    }

    public final ImmutableMessageActionPhoneCall withVideo(boolean value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutableMessageActionPhoneCall(this.identifier, this.flags, value, this.callId, this.reason, this.duration);
    }

    public final ImmutableMessageActionPhoneCall withCallId(long value) {
        if (this.callId == value) {
            return this;
        }
        return new ImmutableMessageActionPhoneCall(this.identifier, this.flags, this.video, value, this.reason, this.duration);
    }

    public final ImmutableMessageActionPhoneCall withReason(@Nullable PhoneCallDiscardReason value) {
        if (this.reason == value) {
            return this;
        }
        return new ImmutableMessageActionPhoneCall(this.identifier, this.flags, this.video, this.callId, value, this.duration);
    }

    public final ImmutableMessageActionPhoneCall withDuration(@Nullable Integer value) {
        if (Objects.equals(this.duration, value)) {
            return this;
        }
        return new ImmutableMessageActionPhoneCall(this.identifier, this.flags, this.video, this.callId, this.reason, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionPhoneCall && this.equalTo(0, (ImmutableMessageActionPhoneCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionPhoneCall another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.video == another.video && this.callId == another.callId && Objects.equals((Object)this.reason, (Object)another.reason) && Objects.equals(this.duration, another.duration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.video);
        h += (h << 5) + Long.hashCode(this.callId);
        h += (h << 5) + Objects.hashCode((Object)this.reason);
        h += (h << 5) + Objects.hashCode(this.duration);
        return h;
    }

    public String toString() {
        return "MessageActionPhoneCall{identifier=" + this.identifier + ", flags=" + this.flags + ", video=" + this.video + ", callId=" + this.callId + ", reason=" + this.reason + ", duration=" + this.duration + "}";
    }

    public static ImmutableMessageActionPhoneCall of(long callId) {
        return new ImmutableMessageActionPhoneCall(callId);
    }

    public static ImmutableMessageActionPhoneCall copyOf(MessageActionPhoneCall instance) {
        if (instance instanceof ImmutableMessageActionPhoneCall) {
            return (ImmutableMessageActionPhoneCall)instance;
        }
        return ImmutableMessageActionPhoneCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_VIDEO = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean video;
        private long callId;
        private PhoneCallDiscardReason reason;
        private Integer duration;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionPhoneCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionPhoneCall) {
                PhoneCallDiscardReason reasonValue;
                instance = (MessageActionPhoneCall)object;
                this.callId(instance.callId());
                Integer durationValue = instance.duration();
                if (durationValue != null) {
                    this.duration(durationValue);
                }
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((reasonValue = instance.reason()) != null) {
                    this.reason(reasonValue);
                }
                this.video(instance.video());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder video(boolean video) {
            this.video = video;
            this.optBits |= 4L;
            return this;
        }

        public final Builder callId(long callId) {
            this.callId = callId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder reason(@Nullable PhoneCallDiscardReason reason) {
            this.reason = reason;
            return this;
        }

        public final Builder duration(@Nullable Integer duration) {
            this.duration = duration;
            return this;
        }

        public ImmutableMessageActionPhoneCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionPhoneCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean videoIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("callId");
            }
            return "Cannot build MessageActionPhoneCall, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte videoBuildStage = 0;
        private boolean video;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageActionPhoneCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageActionPhoneCall.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean video() {
            if (this.videoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoBuildStage == 0) {
                this.videoBuildStage = (byte)-1;
                this.video = ImmutableMessageActionPhoneCall.this.videoInitialize();
                this.videoBuildStage = 1;
            }
            return this.video;
        }

        void video(boolean video) {
            this.video = video;
            this.videoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.videoBuildStage == -1) {
                attributes.add("video");
            }
            return "Cannot build MessageActionPhoneCall, attribute initializers form cycle " + attributes;
        }
    }
}

