/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionPinMessage;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionPinMessage
implements MessageActionPinMessage {
    private final int identifier;
    private static final ImmutableMessageActionPinMessage INSTANCE = ImmutableMessageActionPinMessage.validate(new ImmutableMessageActionPinMessage());

    private ImmutableMessageActionPinMessage() {
        this.identifier = MessageActionPinMessage.super.identifier();
    }

    private ImmutableMessageActionPinMessage(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionPinMessage.super.identifier();
    }

    private ImmutableMessageActionPinMessage(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableMessageActionPinMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageActionPinMessage.validate(new ImmutableMessageActionPinMessage(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionPinMessage && this.equalTo(0, (ImmutableMessageActionPinMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionPinMessage another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "MessageActionPinMessage{identifier=" + this.identifier + "}";
    }

    public static ImmutableMessageActionPinMessage of() {
        return INSTANCE;
    }

    private static ImmutableMessageActionPinMessage validate(ImmutableMessageActionPinMessage instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageActionPinMessage copyOf(MessageActionPinMessage instance) {
        if (instance instanceof ImmutableMessageActionPinMessage) {
            return (ImmutableMessageActionPinMessage)instance;
        }
        return ImmutableMessageActionPinMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionPinMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionPinMessage) {
                instance = (MessageActionPinMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableMessageActionPinMessage build() {
            return ImmutableMessageActionPinMessage.validate(new ImmutableMessageActionPinMessage(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

