/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionSecureValuesSentMe;
import telegram4j.tl.SecureCredentialsEncrypted;
import telegram4j.tl.SecureValue;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionSecureValuesSentMe
implements MessageActionSecureValuesSentMe {
    private final int identifier;
    private final List<SecureValue> values;
    private final SecureCredentialsEncrypted credentials;

    private ImmutableMessageActionSecureValuesSentMe(SecureCredentialsEncrypted credentials) {
        this.credentials = Objects.requireNonNull(credentials, "credentials");
        this.values = Collections.emptyList();
        this.identifier = MessageActionSecureValuesSentMe.super.identifier();
    }

    private ImmutableMessageActionSecureValuesSentMe(Builder builder) {
        this.values = ImmutableMessageActionSecureValuesSentMe.createUnmodifiableList(true, builder.values);
        this.credentials = builder.credentials;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionSecureValuesSentMe.super.identifier();
    }

    private ImmutableMessageActionSecureValuesSentMe(int identifier, List<SecureValue> values, SecureCredentialsEncrypted credentials) {
        this.identifier = identifier;
        this.values = values;
        this.credentials = credentials;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<SecureValue> values() {
        return this.values;
    }

    @Override
    public SecureCredentialsEncrypted credentials() {
        return this.credentials;
    }

    public final ImmutableMessageActionSecureValuesSentMe withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionSecureValuesSentMe(value, this.values, this.credentials);
    }

    public final ImmutableMessageActionSecureValuesSentMe withValues(SecureValue ... elements) {
        List<SecureValue> newValue = ImmutableMessageActionSecureValuesSentMe.createUnmodifiableList(false, ImmutableMessageActionSecureValuesSentMe.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageActionSecureValuesSentMe(this.identifier, newValue, this.credentials);
    }

    public final ImmutableMessageActionSecureValuesSentMe withValues(Iterable<? extends SecureValue> elements) {
        if (this.values == elements) {
            return this;
        }
        List<SecureValue> newValue = ImmutableMessageActionSecureValuesSentMe.createUnmodifiableList(false, ImmutableMessageActionSecureValuesSentMe.createSafeList(elements, true, false));
        return new ImmutableMessageActionSecureValuesSentMe(this.identifier, newValue, this.credentials);
    }

    public final ImmutableMessageActionSecureValuesSentMe withCredentials(SecureCredentialsEncrypted value) {
        if (this.credentials == value) {
            return this;
        }
        SecureCredentialsEncrypted newValue = Objects.requireNonNull(value, "credentials");
        return new ImmutableMessageActionSecureValuesSentMe(this.identifier, this.values, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionSecureValuesSentMe && this.equalTo(0, (ImmutableMessageActionSecureValuesSentMe)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionSecureValuesSentMe another) {
        return this.identifier == another.identifier && this.values.equals(another.values) && this.credentials.equals(another.credentials);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.values.hashCode();
        h += (h << 5) + this.credentials.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionSecureValuesSentMe{identifier=" + this.identifier + ", values=" + this.values + ", credentials=" + this.credentials + "}";
    }

    public static ImmutableMessageActionSecureValuesSentMe of(SecureCredentialsEncrypted credentials) {
        return new ImmutableMessageActionSecureValuesSentMe(credentials);
    }

    public static ImmutableMessageActionSecureValuesSentMe copyOf(MessageActionSecureValuesSentMe instance) {
        if (instance instanceof ImmutableMessageActionSecureValuesSentMe) {
            return (ImmutableMessageActionSecureValuesSentMe)instance;
        }
        return ImmutableMessageActionSecureValuesSentMe.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CREDENTIALS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private List<SecureValue> values = new ArrayList<SecureValue>();
        private SecureCredentialsEncrypted credentials;

        private Builder() {
        }

        public final Builder from(MessageActionSecureValuesSentMe instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageActionSecureValuesSentMe) {
                instance = (MessageActionSecureValuesSentMe)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.credentials(instance.credentials());
                this.addAllValues(instance.values());
            }
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addValue(SecureValue element) {
            this.values.add(Objects.requireNonNull(element, "values element"));
            return this;
        }

        public final Builder addValues(SecureValue ... elements) {
            for (SecureValue element : elements) {
                this.values.add(Objects.requireNonNull(element, "values element"));
            }
            return this;
        }

        public final Builder values(Iterable<? extends SecureValue> elements) {
            this.values.clear();
            return this.addAllValues(elements);
        }

        public final Builder addAllValues(Iterable<? extends SecureValue> elements) {
            for (SecureValue secureValue : elements) {
                this.values.add(Objects.requireNonNull(secureValue, "values element"));
            }
            return this;
        }

        public final Builder credentials(SecureCredentialsEncrypted credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageActionSecureValuesSentMe build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionSecureValuesSentMe(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("credentials");
            }
            return "Cannot build MessageActionSecureValuesSentMe, some of required attributes are not set " + attributes;
        }
    }
}

