/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionSetChatTheme;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionSetChatTheme
implements MessageActionSetChatTheme {
    private final int identifier;
    private final String emoticon;

    private ImmutableMessageActionSetChatTheme(String emoticon) {
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.identifier = MessageActionSetChatTheme.super.identifier();
    }

    private ImmutableMessageActionSetChatTheme(Builder builder) {
        this.emoticon = builder.emoticon;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionSetChatTheme.super.identifier();
    }

    private ImmutableMessageActionSetChatTheme(int identifier, String emoticon) {
        this.identifier = identifier;
        this.emoticon = emoticon;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    public final ImmutableMessageActionSetChatTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionSetChatTheme(value, this.emoticon);
    }

    public final ImmutableMessageActionSetChatTheme withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionSetChatTheme(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionSetChatTheme && this.equalTo(0, (ImmutableMessageActionSetChatTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionSetChatTheme another) {
        return this.identifier == another.identifier && this.emoticon.equals(another.emoticon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emoticon.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionSetChatTheme{identifier=" + this.identifier + ", emoticon=" + this.emoticon + "}";
    }

    public static ImmutableMessageActionSetChatTheme of(String emoticon) {
        return new ImmutableMessageActionSetChatTheme(emoticon);
    }

    public static ImmutableMessageActionSetChatTheme copyOf(MessageActionSetChatTheme instance) {
        if (instance instanceof ImmutableMessageActionSetChatTheme) {
            return (ImmutableMessageActionSetChatTheme)instance;
        }
        return ImmutableMessageActionSetChatTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMOTICON = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String emoticon;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionSetChatTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionSetChatTheme) {
                instance = (MessageActionSetChatTheme)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.emoticon(instance.emoticon());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageActionSetChatTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionSetChatTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoticon");
            }
            return "Cannot build MessageActionSetChatTheme, some of required attributes are not set " + attributes;
        }
    }
}

