/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionSetMessagesTTL;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionSetMessagesTTL
implements MessageActionSetMessagesTTL {
    private final int identifier;
    private final int period;

    private ImmutableMessageActionSetMessagesTTL(int period) {
        this.period = period;
        this.identifier = MessageActionSetMessagesTTL.super.identifier();
    }

    private ImmutableMessageActionSetMessagesTTL(Builder builder) {
        this.period = builder.period;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionSetMessagesTTL.super.identifier();
    }

    private ImmutableMessageActionSetMessagesTTL(int identifier, int period) {
        this.identifier = identifier;
        this.period = period;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int period() {
        return this.period;
    }

    public final ImmutableMessageActionSetMessagesTTL withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionSetMessagesTTL(value, this.period);
    }

    public final ImmutableMessageActionSetMessagesTTL withPeriod(int value) {
        if (this.period == value) {
            return this;
        }
        return new ImmutableMessageActionSetMessagesTTL(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionSetMessagesTTL && this.equalTo(0, (ImmutableMessageActionSetMessagesTTL)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionSetMessagesTTL another) {
        return this.identifier == another.identifier && this.period == another.period;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.period;
        return h;
    }

    public String toString() {
        return "MessageActionSetMessagesTTL{identifier=" + this.identifier + ", period=" + this.period + "}";
    }

    public static ImmutableMessageActionSetMessagesTTL of(int period) {
        return new ImmutableMessageActionSetMessagesTTL(period);
    }

    public static ImmutableMessageActionSetMessagesTTL copyOf(MessageActionSetMessagesTTL instance) {
        if (instance instanceof ImmutableMessageActionSetMessagesTTL) {
            return (ImmutableMessageActionSetMessagesTTL)instance;
        }
        return ImmutableMessageActionSetMessagesTTL.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PERIOD = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int period;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionSetMessagesTTL instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionSetMessagesTTL) {
                instance = (MessageActionSetMessagesTTL)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.period(instance.period());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder period(int period) {
            this.period = period;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageActionSetMessagesTTL build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionSetMessagesTTL(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("period");
            }
            return "Cannot build MessageActionSetMessagesTTL, some of required attributes are not set " + attributes;
        }
    }
}

