/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageActionWebViewDataSentMe;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageActionWebViewDataSentMe
implements MessageActionWebViewDataSentMe {
    private final int identifier;
    private final String text;
    private final String data;

    private ImmutableMessageActionWebViewDataSentMe(String text, String data) {
        this.text = Objects.requireNonNull(text, "text");
        this.data = Objects.requireNonNull(data, "data");
        this.identifier = MessageActionWebViewDataSentMe.super.identifier();
    }

    private ImmutableMessageActionWebViewDataSentMe(Builder builder) {
        this.text = builder.text;
        this.data = builder.data;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageActionWebViewDataSentMe.super.identifier();
    }

    private ImmutableMessageActionWebViewDataSentMe(int identifier, String text, String data) {
        this.identifier = identifier;
        this.text = text;
        this.data = data;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public String data() {
        return this.data;
    }

    public final ImmutableMessageActionWebViewDataSentMe withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageActionWebViewDataSentMe(value, this.text, this.data);
    }

    public final ImmutableMessageActionWebViewDataSentMe withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionWebViewDataSentMe(this.identifier, newValue, this.data);
    }

    public final ImmutableMessageActionWebViewDataSentMe withData(String value) {
        String newValue = Objects.requireNonNull(value, "data");
        if (this.data.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageActionWebViewDataSentMe(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageActionWebViewDataSentMe && this.equalTo(0, (ImmutableMessageActionWebViewDataSentMe)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageActionWebViewDataSentMe another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "MessageActionWebViewDataSentMe{identifier=" + this.identifier + ", text=" + this.text + ", data=" + this.data + "}";
    }

    public static ImmutableMessageActionWebViewDataSentMe of(String text, String data) {
        return new ImmutableMessageActionWebViewDataSentMe(text, data);
    }

    public static ImmutableMessageActionWebViewDataSentMe copyOf(MessageActionWebViewDataSentMe instance) {
        if (instance instanceof ImmutableMessageActionWebViewDataSentMe) {
            return (ImmutableMessageActionWebViewDataSentMe)instance;
        }
        return ImmutableMessageActionWebViewDataSentMe.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_DATA = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String text;
        private String data;

        private Builder() {
        }

        public final Builder from(MessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageActionWebViewDataSentMe instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageAction instance;
            long bits = 0L;
            if (object instanceof MessageAction) {
                instance = (MessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageActionWebViewDataSentMe) {
                instance = (MessageActionWebViewDataSentMe)object;
                this.data(instance.data());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.text(instance.text());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder data(String data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageActionWebViewDataSentMe build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageActionWebViewDataSentMe(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build MessageActionWebViewDataSentMe, some of required attributes are not set " + attributes;
        }
    }
}

