/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Message;
import telegram4j.tl.MessageEmpty;
import telegram4j.tl.Peer;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageEmpty
implements MessageEmpty {
    private final int identifier;
    private final int flags;
    private final int id;
    @Nullable
    private final Peer peerId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageEmpty(int id) {
        this.id = id;
        this.peerId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageEmpty(Builder builder) {
        this.id = builder.id;
        this.peerId = builder.peerId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageEmpty(int identifier, int flags, int id, @Nullable Peer peerId) {
        this.identifier = identifier;
        this.flags = flags;
        this.id = id;
        this.peerId = peerId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageEmpty.super.identifier();
    }

    private int flagsInitialize() {
        return MessageEmpty.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    @Nullable
    public Peer peerId() {
        return this.peerId;
    }

    public final ImmutableMessageEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageEmpty(value, this.flags, this.id, this.peerId);
    }

    public final ImmutableMessageEmpty withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageEmpty(this.identifier, value, this.id, this.peerId);
    }

    public final ImmutableMessageEmpty withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableMessageEmpty(this.identifier, this.flags, value, this.peerId);
    }

    public final ImmutableMessageEmpty withPeerId(@Nullable Peer value) {
        if (this.peerId == value) {
            return this;
        }
        return new ImmutableMessageEmpty(this.identifier, this.flags, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageEmpty && this.equalTo(0, (ImmutableMessageEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageEmpty another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.id == another.id && Objects.equals(this.peerId, another.peerId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.id;
        h += (h << 5) + Objects.hashCode(this.peerId);
        return h;
    }

    public String toString() {
        return "MessageEmpty{identifier=" + this.identifier + ", flags=" + this.flags + ", id=" + this.id + ", peerId=" + this.peerId + "}";
    }

    public static ImmutableMessageEmpty of(int id) {
        return new ImmutableMessageEmpty(id);
    }

    public static ImmutableMessageEmpty copyOf(MessageEmpty instance) {
        if (instance instanceof ImmutableMessageEmpty) {
            return (ImmutableMessageEmpty)instance;
        }
        return ImmutableMessageEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private int id;
        private Peer peerId;

        private Builder() {
        }

        public final Builder from(Message instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Message instance;
            long bits = 0L;
            if (object instanceof Message) {
                instance = (Message)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
            if (object instanceof MessageEmpty) {
                instance = (MessageEmpty)object;
                Peer peerIdValue = instance.peerId();
                if (peerIdValue != null) {
                    this.peerId(peerIdValue);
                }
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder peerId(@Nullable Peer peerId) {
            this.peerId = peerId;
            return this;
        }

        public ImmutableMessageEmpty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageEmpty(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build MessageEmpty, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageEmpty.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageEmpty.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build MessageEmpty, attribute initializers form cycle " + attributes;
        }
    }
}

