/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.MessageEntityCustomEmoji;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageEntityCustomEmoji
implements MessageEntityCustomEmoji {
    private final int identifier;
    private final int offset;
    private final int length;
    private final long documentId;

    private ImmutableMessageEntityCustomEmoji(int offset, int length, long documentId) {
        this.offset = offset;
        this.length = length;
        this.documentId = documentId;
        this.identifier = MessageEntityCustomEmoji.super.identifier();
    }

    private ImmutableMessageEntityCustomEmoji(Builder builder) {
        this.offset = builder.offset;
        this.length = builder.length;
        this.documentId = builder.documentId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageEntityCustomEmoji.super.identifier();
    }

    private ImmutableMessageEntityCustomEmoji(int identifier, int offset, int length, long documentId) {
        this.identifier = identifier;
        this.offset = offset;
        this.length = length;
        this.documentId = documentId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public long documentId() {
        return this.documentId;
    }

    public final ImmutableMessageEntityCustomEmoji withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageEntityCustomEmoji(value, this.offset, this.length, this.documentId);
    }

    public final ImmutableMessageEntityCustomEmoji withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableMessageEntityCustomEmoji(this.identifier, value, this.length, this.documentId);
    }

    public final ImmutableMessageEntityCustomEmoji withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableMessageEntityCustomEmoji(this.identifier, this.offset, value, this.documentId);
    }

    public final ImmutableMessageEntityCustomEmoji withDocumentId(long value) {
        if (this.documentId == value) {
            return this;
        }
        return new ImmutableMessageEntityCustomEmoji(this.identifier, this.offset, this.length, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageEntityCustomEmoji && this.equalTo(0, (ImmutableMessageEntityCustomEmoji)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageEntityCustomEmoji another) {
        return this.identifier == another.identifier && this.offset == another.offset && this.length == another.length && this.documentId == another.documentId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.offset;
        h += (h << 5) + this.length;
        h += (h << 5) + Long.hashCode(this.documentId);
        return h;
    }

    public String toString() {
        return "MessageEntityCustomEmoji{identifier=" + this.identifier + ", offset=" + this.offset + ", length=" + this.length + ", documentId=" + this.documentId + "}";
    }

    public static ImmutableMessageEntityCustomEmoji of(int offset, int length, long documentId) {
        return new ImmutableMessageEntityCustomEmoji(offset, length, documentId);
    }

    public static ImmutableMessageEntityCustomEmoji copyOf(MessageEntityCustomEmoji instance) {
        if (instance instanceof ImmutableMessageEntityCustomEmoji) {
            return (ImmutableMessageEntityCustomEmoji)instance;
        }
        return ImmutableMessageEntityCustomEmoji.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private static final long INIT_BIT_DOCUMENT_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int offset;
        private int length;
        private long documentId;

        private Builder() {
        }

        public final Builder from(MessageEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageEntityCustomEmoji instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageEntity instance;
            long bits = 0L;
            if (object instanceof MessageEntity) {
                instance = (MessageEntity)object;
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageEntityCustomEmoji) {
                instance = (MessageEntityCustomEmoji)object;
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.documentId(instance.documentId());
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder documentId(long documentId) {
            this.documentId = documentId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMessageEntityCustomEmoji build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageEntityCustomEmoji(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("documentId");
            }
            return "Cannot build MessageEntityCustomEmoji, some of required attributes are not set " + attributes;
        }
    }
}

