/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.MessageEntityHashtag;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageEntityHashtag
implements MessageEntityHashtag {
    private final int identifier;
    private final int offset;
    private final int length;

    private ImmutableMessageEntityHashtag(int offset, int length) {
        this.offset = offset;
        this.length = length;
        this.identifier = MessageEntityHashtag.super.identifier();
    }

    private ImmutableMessageEntityHashtag(Builder builder) {
        this.offset = builder.offset;
        this.length = builder.length;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageEntityHashtag.super.identifier();
    }

    private ImmutableMessageEntityHashtag(int identifier, int offset, int length) {
        this.identifier = identifier;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    public final ImmutableMessageEntityHashtag withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageEntityHashtag(value, this.offset, this.length);
    }

    public final ImmutableMessageEntityHashtag withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableMessageEntityHashtag(this.identifier, value, this.length);
    }

    public final ImmutableMessageEntityHashtag withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableMessageEntityHashtag(this.identifier, this.offset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageEntityHashtag && this.equalTo(0, (ImmutableMessageEntityHashtag)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageEntityHashtag another) {
        return this.identifier == another.identifier && this.offset == another.offset && this.length == another.length;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.offset;
        h += (h << 5) + this.length;
        return h;
    }

    public String toString() {
        return "MessageEntityHashtag{identifier=" + this.identifier + ", offset=" + this.offset + ", length=" + this.length + "}";
    }

    public static ImmutableMessageEntityHashtag of(int offset, int length) {
        return new ImmutableMessageEntityHashtag(offset, length);
    }

    public static ImmutableMessageEntityHashtag copyOf(MessageEntityHashtag instance) {
        if (instance instanceof ImmutableMessageEntityHashtag) {
            return (ImmutableMessageEntityHashtag)instance;
        }
        return ImmutableMessageEntityHashtag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int offset;
        private int length;

        private Builder() {
        }

        public final Builder from(MessageEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageEntityHashtag instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageEntity instance;
            long bits = 0L;
            if (object instanceof MessageEntity) {
                instance = (MessageEntity)object;
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageEntityHashtag) {
                instance = (MessageEntityHashtag)object;
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageEntityHashtag build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageEntityHashtag(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build MessageEntityHashtag, some of required attributes are not set " + attributes;
        }
    }
}

