/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.MessageEntityPre;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageEntityPre
implements MessageEntityPre {
    private final int identifier;
    private final int offset;
    private final int length;
    private final String language;

    private ImmutableMessageEntityPre(int offset, int length, String language) {
        this.offset = offset;
        this.length = length;
        this.language = Objects.requireNonNull(language, "language");
        this.identifier = MessageEntityPre.super.identifier();
    }

    private ImmutableMessageEntityPre(Builder builder) {
        this.offset = builder.offset;
        this.length = builder.length;
        this.language = builder.language;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageEntityPre.super.identifier();
    }

    private ImmutableMessageEntityPre(int identifier, int offset, int length, String language) {
        this.identifier = identifier;
        this.offset = offset;
        this.length = length;
        this.language = language;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public String language() {
        return this.language;
    }

    public final ImmutableMessageEntityPre withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageEntityPre(value, this.offset, this.length, this.language);
    }

    public final ImmutableMessageEntityPre withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableMessageEntityPre(this.identifier, value, this.length, this.language);
    }

    public final ImmutableMessageEntityPre withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableMessageEntityPre(this.identifier, this.offset, value, this.language);
    }

    public final ImmutableMessageEntityPre withLanguage(String value) {
        String newValue = Objects.requireNonNull(value, "language");
        if (this.language.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageEntityPre(this.identifier, this.offset, this.length, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageEntityPre && this.equalTo(0, (ImmutableMessageEntityPre)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageEntityPre another) {
        return this.identifier == another.identifier && this.offset == another.offset && this.length == another.length && this.language.equals(another.language);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.offset;
        h += (h << 5) + this.length;
        h += (h << 5) + this.language.hashCode();
        return h;
    }

    public String toString() {
        return "MessageEntityPre{identifier=" + this.identifier + ", offset=" + this.offset + ", length=" + this.length + ", language=" + this.language + "}";
    }

    public static ImmutableMessageEntityPre of(int offset, int length, String language) {
        return new ImmutableMessageEntityPre(offset, length, language);
    }

    public static ImmutableMessageEntityPre copyOf(MessageEntityPre instance) {
        if (instance instanceof ImmutableMessageEntityPre) {
            return (ImmutableMessageEntityPre)instance;
        }
        return ImmutableMessageEntityPre.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private static final long INIT_BIT_LANGUAGE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int offset;
        private int length;
        private String language;

        private Builder() {
        }

        public final Builder from(MessageEntityPre instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageEntity instance;
            long bits = 0L;
            if (object instanceof MessageEntityPre) {
                instance = (MessageEntityPre)object;
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.language(instance.language());
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
            }
            if (object instanceof MessageEntity) {
                instance = (MessageEntity)object;
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder language(String language) {
            this.language = Objects.requireNonNull(language, "language");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMessageEntityPre build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageEntityPre(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("language");
            }
            return "Cannot build MessageEntityPre, some of required attributes are not set " + attributes;
        }
    }
}

