/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.MessageEntityTextUrl;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageEntityTextUrl
implements MessageEntityTextUrl {
    private final int identifier;
    private final int offset;
    private final int length;
    private final String url;

    private ImmutableMessageEntityTextUrl(int offset, int length, String url) {
        this.offset = offset;
        this.length = length;
        this.url = Objects.requireNonNull(url, "url");
        this.identifier = MessageEntityTextUrl.super.identifier();
    }

    private ImmutableMessageEntityTextUrl(Builder builder) {
        this.offset = builder.offset;
        this.length = builder.length;
        this.url = builder.url;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageEntityTextUrl.super.identifier();
    }

    private ImmutableMessageEntityTextUrl(int identifier, int offset, int length, String url) {
        this.identifier = identifier;
        this.offset = offset;
        this.length = length;
        this.url = url;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public String url() {
        return this.url;
    }

    public final ImmutableMessageEntityTextUrl withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageEntityTextUrl(value, this.offset, this.length, this.url);
    }

    public final ImmutableMessageEntityTextUrl withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableMessageEntityTextUrl(this.identifier, value, this.length, this.url);
    }

    public final ImmutableMessageEntityTextUrl withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableMessageEntityTextUrl(this.identifier, this.offset, value, this.url);
    }

    public final ImmutableMessageEntityTextUrl withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageEntityTextUrl(this.identifier, this.offset, this.length, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageEntityTextUrl && this.equalTo(0, (ImmutableMessageEntityTextUrl)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageEntityTextUrl another) {
        return this.identifier == another.identifier && this.offset == another.offset && this.length == another.length && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.offset;
        h += (h << 5) + this.length;
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "MessageEntityTextUrl{identifier=" + this.identifier + ", offset=" + this.offset + ", length=" + this.length + ", url=" + this.url + "}";
    }

    public static ImmutableMessageEntityTextUrl of(int offset, int length, String url) {
        return new ImmutableMessageEntityTextUrl(offset, length, url);
    }

    public static ImmutableMessageEntityTextUrl copyOf(MessageEntityTextUrl instance) {
        if (instance instanceof ImmutableMessageEntityTextUrl) {
            return (ImmutableMessageEntityTextUrl)instance;
        }
        return ImmutableMessageEntityTextUrl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private static final long INIT_BIT_URL = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int offset;
        private int length;
        private String url;

        private Builder() {
        }

        public final Builder from(MessageEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageEntityTextUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageEntity instance;
            long bits = 0L;
            if (object instanceof MessageEntity) {
                instance = (MessageEntity)object;
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageEntityTextUrl) {
                instance = (MessageEntityTextUrl)object;
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
                this.url(instance.url());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMessageEntityTextUrl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageEntityTextUrl(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build MessageEntityTextUrl, some of required attributes are not set " + attributes;
        }
    }
}

