/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageFwdHeader;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageFwdHeader
implements MessageFwdHeader {
    private final int identifier;
    private final int flags;
    private final boolean imported;
    @Nullable
    private final Peer fromId;
    @Nullable
    private final String fromName;
    private final int date;
    @Nullable
    private final Integer channelPost;
    @Nullable
    private final String postAuthor;
    @Nullable
    private final Peer savedFromPeer;
    @Nullable
    private final Integer savedFromMsgId;
    @Nullable
    private final String psaType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageFwdHeader(int date) {
        this.date = date;
        this.fromId = null;
        this.fromName = null;
        this.channelPost = null;
        this.postAuthor = null;
        this.savedFromPeer = null;
        this.savedFromMsgId = null;
        this.psaType = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.imported = this.initShim.imported();
        this.initShim = null;
    }

    private ImmutableMessageFwdHeader(Builder builder) {
        this.fromId = builder.fromId;
        this.fromName = builder.fromName;
        this.date = builder.date;
        this.channelPost = builder.channelPost;
        this.postAuthor = builder.postAuthor;
        this.savedFromPeer = builder.savedFromPeer;
        this.savedFromMsgId = builder.savedFromMsgId;
        this.psaType = builder.psaType;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.importedIsSet()) {
            this.initShim.imported(builder.imported);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.imported = this.initShim.imported();
        this.initShim = null;
    }

    private ImmutableMessageFwdHeader(int identifier, int flags, boolean imported, @Nullable Peer fromId, @Nullable String fromName, int date, @Nullable Integer channelPost, @Nullable String postAuthor, @Nullable Peer savedFromPeer, @Nullable Integer savedFromMsgId, @Nullable String psaType) {
        this.identifier = identifier;
        this.flags = flags;
        this.imported = imported;
        this.fromId = fromId;
        this.fromName = fromName;
        this.date = date;
        this.channelPost = channelPost;
        this.postAuthor = postAuthor;
        this.savedFromPeer = savedFromPeer;
        this.savedFromMsgId = savedFromMsgId;
        this.psaType = psaType;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageFwdHeader.super.identifier();
    }

    private int flagsInitialize() {
        return MessageFwdHeader.super.flags();
    }

    private boolean importedInitialize() {
        return MessageFwdHeader.super.imported();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean imported() {
        InitShim shim = this.initShim;
        return shim != null ? shim.imported() : this.imported;
    }

    @Override
    @Nullable
    public Peer fromId() {
        return this.fromId;
    }

    @Override
    @Nullable
    public String fromName() {
        return this.fromName;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    @Nullable
    public Integer channelPost() {
        return this.channelPost;
    }

    @Override
    @Nullable
    public String postAuthor() {
        return this.postAuthor;
    }

    @Override
    @Nullable
    public Peer savedFromPeer() {
        return this.savedFromPeer;
    }

    @Override
    @Nullable
    public Integer savedFromMsgId() {
        return this.savedFromMsgId;
    }

    @Override
    @Nullable
    public String psaType() {
        return this.psaType;
    }

    public final ImmutableMessageFwdHeader withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageFwdHeader(value, this.flags, this.imported, this.fromId, this.fromName, this.date, this.channelPost, this.postAuthor, this.savedFromPeer, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, value, this.imported, this.fromId, this.fromName, this.date, this.channelPost, this.postAuthor, this.savedFromPeer, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withImported(boolean value) {
        if (this.imported == value) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, value, this.fromId, this.fromName, this.date, this.channelPost, this.postAuthor, this.savedFromPeer, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withFromId(@Nullable Peer value) {
        if (this.fromId == value) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, this.imported, value, this.fromName, this.date, this.channelPost, this.postAuthor, this.savedFromPeer, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withFromName(@Nullable String value) {
        if (Objects.equals(this.fromName, value)) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, this.imported, this.fromId, value, this.date, this.channelPost, this.postAuthor, this.savedFromPeer, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, this.imported, this.fromId, this.fromName, value, this.channelPost, this.postAuthor, this.savedFromPeer, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withChannelPost(@Nullable Integer value) {
        if (Objects.equals(this.channelPost, value)) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, this.imported, this.fromId, this.fromName, this.date, value, this.postAuthor, this.savedFromPeer, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withPostAuthor(@Nullable String value) {
        if (Objects.equals(this.postAuthor, value)) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, this.imported, this.fromId, this.fromName, this.date, this.channelPost, value, this.savedFromPeer, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withSavedFromPeer(@Nullable Peer value) {
        if (this.savedFromPeer == value) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, this.imported, this.fromId, this.fromName, this.date, this.channelPost, this.postAuthor, value, this.savedFromMsgId, this.psaType);
    }

    public final ImmutableMessageFwdHeader withSavedFromMsgId(@Nullable Integer value) {
        if (Objects.equals(this.savedFromMsgId, value)) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, this.imported, this.fromId, this.fromName, this.date, this.channelPost, this.postAuthor, this.savedFromPeer, value, this.psaType);
    }

    public final ImmutableMessageFwdHeader withPsaType(@Nullable String value) {
        if (Objects.equals(this.psaType, value)) {
            return this;
        }
        return new ImmutableMessageFwdHeader(this.identifier, this.flags, this.imported, this.fromId, this.fromName, this.date, this.channelPost, this.postAuthor, this.savedFromPeer, this.savedFromMsgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageFwdHeader && this.equalTo(0, (ImmutableMessageFwdHeader)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageFwdHeader another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.imported == another.imported && Objects.equals(this.fromId, another.fromId) && Objects.equals(this.fromName, another.fromName) && this.date == another.date && Objects.equals(this.channelPost, another.channelPost) && Objects.equals(this.postAuthor, another.postAuthor) && Objects.equals(this.savedFromPeer, another.savedFromPeer) && Objects.equals(this.savedFromMsgId, another.savedFromMsgId) && Objects.equals(this.psaType, another.psaType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.imported);
        h += (h << 5) + Objects.hashCode(this.fromId);
        h += (h << 5) + Objects.hashCode(this.fromName);
        h += (h << 5) + this.date;
        h += (h << 5) + Objects.hashCode(this.channelPost);
        h += (h << 5) + Objects.hashCode(this.postAuthor);
        h += (h << 5) + Objects.hashCode(this.savedFromPeer);
        h += (h << 5) + Objects.hashCode(this.savedFromMsgId);
        h += (h << 5) + Objects.hashCode(this.psaType);
        return h;
    }

    public String toString() {
        return "MessageFwdHeader{identifier=" + this.identifier + ", flags=" + this.flags + ", imported=" + this.imported + ", fromId=" + this.fromId + ", fromName=" + this.fromName + ", date=" + this.date + ", channelPost=" + this.channelPost + ", postAuthor=" + this.postAuthor + ", savedFromPeer=" + this.savedFromPeer + ", savedFromMsgId=" + this.savedFromMsgId + ", psaType=" + this.psaType + "}";
    }

    public static ImmutableMessageFwdHeader of(int date) {
        return new ImmutableMessageFwdHeader(date);
    }

    public static ImmutableMessageFwdHeader copyOf(MessageFwdHeader instance) {
        if (instance instanceof ImmutableMessageFwdHeader) {
            return (ImmutableMessageFwdHeader)instance;
        }
        return ImmutableMessageFwdHeader.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_IMPORTED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean imported;
        private Peer fromId;
        private String fromName;
        private int date;
        private Integer channelPost;
        private String postAuthor;
        private Peer savedFromPeer;
        private Integer savedFromMsgId;
        private String psaType;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageFwdHeader instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageFwdHeader) {
                String psaTypeValue;
                Peer fromIdValue;
                Integer savedFromMsgIdValue;
                Integer channelPostValue;
                String postAuthorValue;
                instance = (MessageFwdHeader)object;
                this.date(instance.date());
                Peer savedFromPeerValue = instance.savedFromPeer();
                if (savedFromPeerValue != null) {
                    this.savedFromPeer(savedFromPeerValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((postAuthorValue = instance.postAuthor()) != null) {
                    this.postAuthor(postAuthorValue);
                }
                if ((channelPostValue = instance.channelPost()) != null) {
                    this.channelPost(channelPostValue);
                }
                this.imported(instance.imported());
                this.flags(instance.flags());
                String fromNameValue = instance.fromName();
                if (fromNameValue != null) {
                    this.fromName(fromNameValue);
                }
                if ((savedFromMsgIdValue = instance.savedFromMsgId()) != null) {
                    this.savedFromMsgId(savedFromMsgIdValue);
                }
                if ((fromIdValue = instance.fromId()) != null) {
                    this.fromId(fromIdValue);
                }
                if ((psaTypeValue = instance.psaType()) != null) {
                    this.psaType(psaTypeValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder imported(boolean imported) {
            this.imported = imported;
            this.optBits |= 4L;
            return this;
        }

        public final Builder fromId(@Nullable Peer fromId) {
            this.fromId = fromId;
            return this;
        }

        public final Builder fromName(@Nullable String fromName) {
            this.fromName = fromName;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder channelPost(@Nullable Integer channelPost) {
            this.channelPost = channelPost;
            return this;
        }

        public final Builder postAuthor(@Nullable String postAuthor) {
            this.postAuthor = postAuthor;
            return this;
        }

        public final Builder savedFromPeer(@Nullable Peer savedFromPeer) {
            this.savedFromPeer = savedFromPeer;
            return this;
        }

        public final Builder savedFromMsgId(@Nullable Integer savedFromMsgId) {
            this.savedFromMsgId = savedFromMsgId;
            return this;
        }

        public final Builder psaType(@Nullable String psaType) {
            this.psaType = psaType;
            return this;
        }

        public ImmutableMessageFwdHeader build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageFwdHeader(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean importedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build MessageFwdHeader, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte importedBuildStage = 0;
        private boolean imported;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageFwdHeader.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageFwdHeader.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean imported() {
            if (this.importedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.importedBuildStage == 0) {
                this.importedBuildStage = (byte)-1;
                this.imported = ImmutableMessageFwdHeader.this.importedInitialize();
                this.importedBuildStage = 1;
            }
            return this.imported;
        }

        void imported(boolean imported) {
            this.imported = imported;
            this.importedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.importedBuildStage == -1) {
                attributes.add("imported");
            }
            return "Cannot build MessageFwdHeader, attribute initializers form cycle " + attributes;
        }
    }
}

