/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageInteractionCounters;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageInteractionCounters
implements MessageInteractionCounters {
    private final int identifier;
    private final int msgId;
    private final int views;
    private final int forwards;

    private ImmutableMessageInteractionCounters(int msgId, int views, int forwards) {
        this.msgId = msgId;
        this.views = views;
        this.forwards = forwards;
        this.identifier = MessageInteractionCounters.super.identifier();
    }

    private ImmutableMessageInteractionCounters(Builder builder) {
        this.msgId = builder.msgId;
        this.views = builder.views;
        this.forwards = builder.forwards;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageInteractionCounters.super.identifier();
    }

    private ImmutableMessageInteractionCounters(int identifier, int msgId, int views, int forwards) {
        this.identifier = identifier;
        this.msgId = msgId;
        this.views = views;
        this.forwards = forwards;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public int views() {
        return this.views;
    }

    @Override
    public int forwards() {
        return this.forwards;
    }

    public final ImmutableMessageInteractionCounters withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageInteractionCounters(value, this.msgId, this.views, this.forwards);
    }

    public final ImmutableMessageInteractionCounters withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableMessageInteractionCounters(this.identifier, value, this.views, this.forwards);
    }

    public final ImmutableMessageInteractionCounters withViews(int value) {
        if (this.views == value) {
            return this;
        }
        return new ImmutableMessageInteractionCounters(this.identifier, this.msgId, value, this.forwards);
    }

    public final ImmutableMessageInteractionCounters withForwards(int value) {
        if (this.forwards == value) {
            return this;
        }
        return new ImmutableMessageInteractionCounters(this.identifier, this.msgId, this.views, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageInteractionCounters && this.equalTo(0, (ImmutableMessageInteractionCounters)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageInteractionCounters another) {
        return this.identifier == another.identifier && this.msgId == another.msgId && this.views == another.views && this.forwards == another.forwards;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.msgId;
        h += (h << 5) + this.views;
        h += (h << 5) + this.forwards;
        return h;
    }

    public String toString() {
        return "MessageInteractionCounters{identifier=" + this.identifier + ", msgId=" + this.msgId + ", views=" + this.views + ", forwards=" + this.forwards + "}";
    }

    public static ImmutableMessageInteractionCounters of(int msgId, int views, int forwards) {
        return new ImmutableMessageInteractionCounters(msgId, views, forwards);
    }

    public static ImmutableMessageInteractionCounters copyOf(MessageInteractionCounters instance) {
        if (instance instanceof ImmutableMessageInteractionCounters) {
            return (ImmutableMessageInteractionCounters)instance;
        }
        return ImmutableMessageInteractionCounters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MSG_ID = 1L;
        private static final long INIT_BIT_VIEWS = 2L;
        private static final long INIT_BIT_FORWARDS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int msgId;
        private int views;
        private int forwards;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageInteractionCounters instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageInteractionCounters) {
                instance = (MessageInteractionCounters)object;
                this.forwards(instance.forwards());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.views(instance.views());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder views(int views) {
            this.views = views;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder forwards(int forwards) {
            this.forwards = forwards;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMessageInteractionCounters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageInteractionCounters(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("views");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("forwards");
            }
            return "Cannot build MessageInteractionCounters, some of required attributes are not set " + attributes;
        }
    }
}

