/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaContact;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaContact
implements MessageMediaContact {
    private final int identifier;
    private final String phoneNumber;
    private final String firstName;
    private final String lastName;
    private final String vcard;
    private final long userId;

    private ImmutableMessageMediaContact(String phoneNumber, String firstName, String lastName, String vcard, long userId) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.firstName = Objects.requireNonNull(firstName, "firstName");
        this.lastName = Objects.requireNonNull(lastName, "lastName");
        this.vcard = Objects.requireNonNull(vcard, "vcard");
        this.userId = userId;
        this.identifier = MessageMediaContact.super.identifier();
    }

    private ImmutableMessageMediaContact(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.vcard = builder.vcard;
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageMediaContact.super.identifier();
    }

    private ImmutableMessageMediaContact(int identifier, String phoneNumber, String firstName, String lastName, String vcard, long userId) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.firstName = firstName;
        this.lastName = lastName;
        this.vcard = vcard;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String firstName() {
        return this.firstName;
    }

    @Override
    public String lastName() {
        return this.lastName;
    }

    @Override
    public String vcard() {
        return this.vcard;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    public final ImmutableMessageMediaContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageMediaContact(value, this.phoneNumber, this.firstName, this.lastName, this.vcard, this.userId);
    }

    public final ImmutableMessageMediaContact withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaContact(this.identifier, newValue, this.firstName, this.lastName, this.vcard, this.userId);
    }

    public final ImmutableMessageMediaContact withFirstName(String value) {
        String newValue = Objects.requireNonNull(value, "firstName");
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaContact(this.identifier, this.phoneNumber, newValue, this.lastName, this.vcard, this.userId);
    }

    public final ImmutableMessageMediaContact withLastName(String value) {
        String newValue = Objects.requireNonNull(value, "lastName");
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaContact(this.identifier, this.phoneNumber, this.firstName, newValue, this.vcard, this.userId);
    }

    public final ImmutableMessageMediaContact withVcard(String value) {
        String newValue = Objects.requireNonNull(value, "vcard");
        if (this.vcard.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaContact(this.identifier, this.phoneNumber, this.firstName, this.lastName, newValue, this.userId);
    }

    public final ImmutableMessageMediaContact withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableMessageMediaContact(this.identifier, this.phoneNumber, this.firstName, this.lastName, this.vcard, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaContact && this.equalTo(0, (ImmutableMessageMediaContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaContact another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName) && this.vcard.equals(another.vcard) && this.userId == another.userId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.firstName.hashCode();
        h += (h << 5) + this.lastName.hashCode();
        h += (h << 5) + this.vcard.hashCode();
        h += (h << 5) + Long.hashCode(this.userId);
        return h;
    }

    public String toString() {
        return "MessageMediaContact{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", vcard=" + this.vcard + ", userId=" + this.userId + "}";
    }

    public static ImmutableMessageMediaContact of(String phoneNumber, String firstName, String lastName, String vcard, long userId) {
        return new ImmutableMessageMediaContact(phoneNumber, firstName, lastName, vcard, userId);
    }

    public static ImmutableMessageMediaContact copyOf(MessageMediaContact instance) {
        if (instance instanceof ImmutableMessageMediaContact) {
            return (ImmutableMessageMediaContact)instance;
        }
        return ImmutableMessageMediaContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_FIRST_NAME = 2L;
        private static final long INIT_BIT_LAST_NAME = 4L;
        private static final long INIT_BIT_VCARD = 8L;
        private static final long INIT_BIT_USER_ID = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private String firstName;
        private String lastName;
        private String vcard;
        private long userId;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaContact) {
                instance = (MessageMediaContact)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.firstName(instance.firstName());
                this.lastName(instance.lastName());
                this.phoneNumber(instance.phoneNumber());
                this.vcard(instance.vcard());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder firstName(String firstName) {
            this.firstName = Objects.requireNonNull(firstName, "firstName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastName(String lastName) {
            this.lastName = Objects.requireNonNull(lastName, "lastName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder vcard(String vcard) {
            this.vcard = Objects.requireNonNull(vcard, "vcard");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableMessageMediaContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageMediaContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("firstName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("vcard");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build MessageMediaContact, some of required attributes are not set " + attributes;
        }
    }
}

