/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaDice;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaDice
implements MessageMediaDice {
    private final int identifier;
    private final int value;
    private final String emoticon;

    private ImmutableMessageMediaDice(int value, String emoticon) {
        this.value = value;
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.identifier = MessageMediaDice.super.identifier();
    }

    private ImmutableMessageMediaDice(Builder builder) {
        this.value = builder.value;
        this.emoticon = builder.emoticon;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageMediaDice.super.identifier();
    }

    private ImmutableMessageMediaDice(int identifier, int value, String emoticon) {
        this.identifier = identifier;
        this.value = value;
        this.emoticon = emoticon;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    public final ImmutableMessageMediaDice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageMediaDice(value, this.value, this.emoticon);
    }

    public final ImmutableMessageMediaDice withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableMessageMediaDice(this.identifier, value, this.emoticon);
    }

    public final ImmutableMessageMediaDice withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaDice(this.identifier, this.value, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaDice && this.equalTo(0, (ImmutableMessageMediaDice)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaDice another) {
        return this.identifier == another.identifier && this.value == another.value && this.emoticon.equals(another.emoticon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.value;
        h += (h << 5) + this.emoticon.hashCode();
        return h;
    }

    public String toString() {
        return "MessageMediaDice{identifier=" + this.identifier + ", value=" + this.value + ", emoticon=" + this.emoticon + "}";
    }

    public static ImmutableMessageMediaDice of(int value, String emoticon) {
        return new ImmutableMessageMediaDice(value, emoticon);
    }

    public static ImmutableMessageMediaDice copyOf(MessageMediaDice instance) {
        if (instance instanceof ImmutableMessageMediaDice) {
            return (ImmutableMessageMediaDice)instance;
        }
        return ImmutableMessageMediaDice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_EMOTICON = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int value;
        private String emoticon;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaDice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaDice) {
                instance = (MessageMediaDice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.value(instance.value());
                this.emoticon(instance.emoticon());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageMediaDice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageMediaDice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("emoticon");
            }
            return "Cannot build MessageMediaDice, some of required attributes are not set " + attributes;
        }
    }
}

