/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Document;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaDocument;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaDocument
implements MessageMediaDocument {
    private final int identifier;
    private final int flags;
    private final boolean nopremium;
    @Nullable
    private final Document document;
    @Nullable
    private final Integer ttlSeconds;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableMessageMediaDocument INSTANCE = ImmutableMessageMediaDocument.validate(new ImmutableMessageMediaDocument());

    private ImmutableMessageMediaDocument() {
        this.document = null;
        this.ttlSeconds = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.nopremium = this.initShim.nopremium();
        this.initShim = null;
    }

    private ImmutableMessageMediaDocument(Builder builder) {
        this.document = builder.document;
        this.ttlSeconds = builder.ttlSeconds;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.nopremiumIsSet()) {
            this.initShim.nopremium(builder.nopremium);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.nopremium = this.initShim.nopremium();
        this.initShim = null;
    }

    private ImmutableMessageMediaDocument(int identifier, int flags, boolean nopremium, @Nullable Document document, @Nullable Integer ttlSeconds) {
        this.identifier = identifier;
        this.flags = flags;
        this.nopremium = nopremium;
        this.document = document;
        this.ttlSeconds = ttlSeconds;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageMediaDocument.super.identifier();
    }

    private int flagsInitialize() {
        return MessageMediaDocument.super.flags();
    }

    private boolean nopremiumInitialize() {
        return MessageMediaDocument.super.nopremium();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean nopremium() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nopremium() : this.nopremium;
    }

    @Override
    @Nullable
    public Document document() {
        return this.document;
    }

    @Override
    @Nullable
    public Integer ttlSeconds() {
        return this.ttlSeconds;
    }

    public final ImmutableMessageMediaDocument withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageMediaDocument.validate(new ImmutableMessageMediaDocument(value, this.flags, this.nopremium, this.document, this.ttlSeconds));
    }

    public final ImmutableMessageMediaDocument withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableMessageMediaDocument.validate(new ImmutableMessageMediaDocument(this.identifier, value, this.nopremium, this.document, this.ttlSeconds));
    }

    public final ImmutableMessageMediaDocument withNopremium(boolean value) {
        if (this.nopremium == value) {
            return this;
        }
        return ImmutableMessageMediaDocument.validate(new ImmutableMessageMediaDocument(this.identifier, this.flags, value, this.document, this.ttlSeconds));
    }

    public final ImmutableMessageMediaDocument withDocument(@Nullable Document value) {
        if (this.document == value) {
            return this;
        }
        return ImmutableMessageMediaDocument.validate(new ImmutableMessageMediaDocument(this.identifier, this.flags, this.nopremium, value, this.ttlSeconds));
    }

    public final ImmutableMessageMediaDocument withTtlSeconds(@Nullable Integer value) {
        if (Objects.equals(this.ttlSeconds, value)) {
            return this;
        }
        return ImmutableMessageMediaDocument.validate(new ImmutableMessageMediaDocument(this.identifier, this.flags, this.nopremium, this.document, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaDocument && this.equalTo(0, (ImmutableMessageMediaDocument)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaDocument another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.nopremium == another.nopremium && Objects.equals(this.document, another.document) && Objects.equals(this.ttlSeconds, another.ttlSeconds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.nopremium);
        h += (h << 5) + Objects.hashCode(this.document);
        h += (h << 5) + Objects.hashCode(this.ttlSeconds);
        return h;
    }

    public String toString() {
        return "MessageMediaDocument{identifier=" + this.identifier + ", flags=" + this.flags + ", nopremium=" + this.nopremium + ", document=" + this.document + ", ttlSeconds=" + this.ttlSeconds + "}";
    }

    public static ImmutableMessageMediaDocument of() {
        return INSTANCE;
    }

    private static ImmutableMessageMediaDocument validate(ImmutableMessageMediaDocument instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageMediaDocument copyOf(MessageMediaDocument instance) {
        if (instance instanceof ImmutableMessageMediaDocument) {
            return (ImmutableMessageMediaDocument)instance;
        }
        return ImmutableMessageMediaDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NOPREMIUM = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean nopremium;
        private Document document;
        private Integer ttlSeconds;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaDocument) {
                Document documentValue;
                Integer ttlSecondsValue;
                instance = (MessageMediaDocument)object;
                this.flags(instance.flags());
                this.nopremium(instance.nopremium());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((ttlSecondsValue = instance.ttlSeconds()) != null) {
                    this.ttlSeconds(ttlSecondsValue);
                }
                if ((documentValue = instance.document()) != null) {
                    this.document(documentValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder nopremium(boolean nopremium) {
            this.nopremium = nopremium;
            this.optBits |= 4L;
            return this;
        }

        public final Builder document(@Nullable Document document) {
            this.document = document;
            return this;
        }

        public final Builder ttlSeconds(@Nullable Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public ImmutableMessageMediaDocument build() {
            return ImmutableMessageMediaDocument.validate(new ImmutableMessageMediaDocument(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean nopremiumIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte nopremiumBuildStage = 0;
        private boolean nopremium;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageMediaDocument.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageMediaDocument.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean nopremium() {
            if (this.nopremiumBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nopremiumBuildStage == 0) {
                this.nopremiumBuildStage = (byte)-1;
                this.nopremium = ImmutableMessageMediaDocument.this.nopremiumInitialize();
                this.nopremiumBuildStage = 1;
            }
            return this.nopremium;
        }

        void nopremium(boolean nopremium) {
            this.nopremium = nopremium;
            this.nopremiumBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.nopremiumBuildStage == -1) {
                attributes.add("nopremium");
            }
            return "Cannot build MessageMediaDocument, attribute initializers form cycle " + attributes;
        }
    }
}

