/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaEmpty
implements MessageMediaEmpty {
    private final int identifier;
    private static final ImmutableMessageMediaEmpty INSTANCE = ImmutableMessageMediaEmpty.validate(new ImmutableMessageMediaEmpty());

    private ImmutableMessageMediaEmpty() {
        this.identifier = MessageMediaEmpty.super.identifier();
    }

    private ImmutableMessageMediaEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageMediaEmpty.super.identifier();
    }

    private ImmutableMessageMediaEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableMessageMediaEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageMediaEmpty.validate(new ImmutableMessageMediaEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaEmpty && this.equalTo(0, (ImmutableMessageMediaEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "MessageMediaEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableMessageMediaEmpty of() {
        return INSTANCE;
    }

    private static ImmutableMessageMediaEmpty validate(ImmutableMessageMediaEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageMediaEmpty copyOf(MessageMediaEmpty instance) {
        if (instance instanceof ImmutableMessageMediaEmpty) {
            return (ImmutableMessageMediaEmpty)instance;
        }
        return ImmutableMessageMediaEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaEmpty) {
                instance = (MessageMediaEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableMessageMediaEmpty build() {
            return ImmutableMessageMediaEmpty.validate(new ImmutableMessageMediaEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

