/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Game;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaGame;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaGame
implements MessageMediaGame {
    private final int identifier;
    private final Game game;

    private ImmutableMessageMediaGame(Game game) {
        this.game = Objects.requireNonNull(game, "game");
        this.identifier = MessageMediaGame.super.identifier();
    }

    private ImmutableMessageMediaGame(Builder builder) {
        this.game = builder.game;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageMediaGame.super.identifier();
    }

    private ImmutableMessageMediaGame(int identifier, Game game) {
        this.identifier = identifier;
        this.game = game;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Game game() {
        return this.game;
    }

    public final ImmutableMessageMediaGame withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageMediaGame(value, this.game);
    }

    public final ImmutableMessageMediaGame withGame(Game value) {
        if (this.game == value) {
            return this;
        }
        Game newValue = Objects.requireNonNull(value, "game");
        return new ImmutableMessageMediaGame(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaGame && this.equalTo(0, (ImmutableMessageMediaGame)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaGame another) {
        return this.identifier == another.identifier && this.game.equals(another.game);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.game.hashCode();
        return h;
    }

    public String toString() {
        return "MessageMediaGame{identifier=" + this.identifier + ", game=" + this.game + "}";
    }

    public static ImmutableMessageMediaGame of(Game game) {
        return new ImmutableMessageMediaGame(game);
    }

    public static ImmutableMessageMediaGame copyOf(MessageMediaGame instance) {
        if (instance instanceof ImmutableMessageMediaGame) {
            return (ImmutableMessageMediaGame)instance;
        }
        return ImmutableMessageMediaGame.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GAME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Game game;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaGame instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaGame) {
                instance = (MessageMediaGame)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.game(instance.game());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder game(Game game) {
            this.game = Objects.requireNonNull(game, "game");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageMediaGame build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageMediaGame(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("game");
            }
            return "Cannot build MessageMediaGame, some of required attributes are not set " + attributes;
        }
    }
}

