/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.GeoPoint;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaGeoLive;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaGeoLive
implements MessageMediaGeoLive {
    private final int identifier;
    private final int flags;
    private final GeoPoint geo;
    @Nullable
    private final Integer heading;
    private final int period;
    @Nullable
    private final Integer proximityNotificationRadius;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageMediaGeoLive(GeoPoint geo, int period) {
        this.geo = Objects.requireNonNull(geo, "geo");
        this.period = period;
        this.heading = null;
        this.proximityNotificationRadius = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageMediaGeoLive(Builder builder) {
        this.geo = builder.geo;
        this.heading = builder.heading;
        this.period = builder.period;
        this.proximityNotificationRadius = builder.proximityNotificationRadius;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageMediaGeoLive(int identifier, int flags, GeoPoint geo, @Nullable Integer heading, int period, @Nullable Integer proximityNotificationRadius) {
        this.identifier = identifier;
        this.flags = flags;
        this.geo = geo;
        this.heading = heading;
        this.period = period;
        this.proximityNotificationRadius = proximityNotificationRadius;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageMediaGeoLive.super.identifier();
    }

    private int flagsInitialize() {
        return MessageMediaGeoLive.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public GeoPoint geo() {
        return this.geo;
    }

    @Override
    @Nullable
    public Integer heading() {
        return this.heading;
    }

    @Override
    public int period() {
        return this.period;
    }

    @Override
    @Nullable
    public Integer proximityNotificationRadius() {
        return this.proximityNotificationRadius;
    }

    public final ImmutableMessageMediaGeoLive withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageMediaGeoLive(value, this.flags, this.geo, this.heading, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableMessageMediaGeoLive withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageMediaGeoLive(this.identifier, value, this.geo, this.heading, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableMessageMediaGeoLive withGeo(GeoPoint value) {
        if (this.geo == value) {
            return this;
        }
        GeoPoint newValue = Objects.requireNonNull(value, "geo");
        return new ImmutableMessageMediaGeoLive(this.identifier, this.flags, newValue, this.heading, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableMessageMediaGeoLive withHeading(@Nullable Integer value) {
        if (Objects.equals(this.heading, value)) {
            return this;
        }
        return new ImmutableMessageMediaGeoLive(this.identifier, this.flags, this.geo, value, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableMessageMediaGeoLive withPeriod(int value) {
        if (this.period == value) {
            return this;
        }
        return new ImmutableMessageMediaGeoLive(this.identifier, this.flags, this.geo, this.heading, value, this.proximityNotificationRadius);
    }

    public final ImmutableMessageMediaGeoLive withProximityNotificationRadius(@Nullable Integer value) {
        if (Objects.equals(this.proximityNotificationRadius, value)) {
            return this;
        }
        return new ImmutableMessageMediaGeoLive(this.identifier, this.flags, this.geo, this.heading, this.period, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaGeoLive && this.equalTo(0, (ImmutableMessageMediaGeoLive)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaGeoLive another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.geo.equals(another.geo) && Objects.equals(this.heading, another.heading) && this.period == another.period && Objects.equals(this.proximityNotificationRadius, another.proximityNotificationRadius);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.geo.hashCode();
        h += (h << 5) + Objects.hashCode(this.heading);
        h += (h << 5) + this.period;
        h += (h << 5) + Objects.hashCode(this.proximityNotificationRadius);
        return h;
    }

    public String toString() {
        return "MessageMediaGeoLive{identifier=" + this.identifier + ", flags=" + this.flags + ", geo=" + this.geo + ", heading=" + this.heading + ", period=" + this.period + ", proximityNotificationRadius=" + this.proximityNotificationRadius + "}";
    }

    public static ImmutableMessageMediaGeoLive of(GeoPoint geo, int period) {
        return new ImmutableMessageMediaGeoLive(geo, period);
    }

    public static ImmutableMessageMediaGeoLive copyOf(MessageMediaGeoLive instance) {
        if (instance instanceof ImmutableMessageMediaGeoLive) {
            return (ImmutableMessageMediaGeoLive)instance;
        }
        return ImmutableMessageMediaGeoLive.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO = 1L;
        private static final long INIT_BIT_PERIOD = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private GeoPoint geo;
        private Integer heading;
        private int period;
        private Integer proximityNotificationRadius;

        private Builder() {
        }

        public final Builder from(MessageMediaGeoLive instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMediaGeoLive) {
                Integer proximityNotificationRadiusValue;
                instance = (MessageMediaGeoLive)object;
                this.geo(instance.geo());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.period(instance.period());
                Integer headingValue = instance.heading();
                if (headingValue != null) {
                    this.heading(headingValue);
                }
                if ((proximityNotificationRadiusValue = instance.proximityNotificationRadius()) != null) {
                    this.proximityNotificationRadius(proximityNotificationRadiusValue);
                }
            }
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder geo(GeoPoint geo) {
            this.geo = Objects.requireNonNull(geo, "geo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder heading(@Nullable Integer heading) {
            this.heading = heading;
            return this;
        }

        public final Builder period(int period) {
            this.period = period;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder proximityNotificationRadius(@Nullable Integer proximityNotificationRadius) {
            this.proximityNotificationRadius = proximityNotificationRadius;
            return this;
        }

        public ImmutableMessageMediaGeoLive build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageMediaGeoLive(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("period");
            }
            return "Cannot build MessageMediaGeoLive, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageMediaGeoLive.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageMediaGeoLive.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build MessageMediaGeoLive, attribute initializers form cycle " + attributes;
        }
    }
}

